package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{BooleanType, KeyIdType}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifyMacResponse(
    keyId: Optional[KeyIdType] = Optional.Absent,
    macValid: Optional[BooleanType] = Optional.Absent,
    macAlgorithm: Optional[zio.aws.kms.model.MacAlgorithmSpec] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.VerifyMacResponse = {
    import VerifyMacResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.VerifyMacResponse
      .builder()
      .optionallyWith(
        keyId.map(value => KeyIdType.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        macValid.map(value => BooleanType.unwrap(value): java.lang.Boolean)
      )(_.macValid)
      .optionallyWith(macAlgorithm.map(value => value.unwrap))(_.macAlgorithm)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.VerifyMacResponse.ReadOnly =
    zio.aws.kms.model.VerifyMacResponse.wrap(buildAwsValue())
}
object VerifyMacResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.VerifyMacResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.VerifyMacResponse =
      zio.aws.kms.model.VerifyMacResponse(
        keyId.map(value => value),
        macValid.map(value => value),
        macAlgorithm.map(value => value)
      )
    def keyId: Optional[KeyIdType]
    def macValid: Optional[BooleanType]
    def macAlgorithm: Optional[zio.aws.kms.model.MacAlgorithmSpec]
    def getKeyId: ZIO[Any, AwsError, KeyIdType] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getMacValid: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("macValid", macValid)
    def getMacAlgorithm
        : ZIO[Any, AwsError, zio.aws.kms.model.MacAlgorithmSpec] =
      AwsError.unwrapOptionField("macAlgorithm", macAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.VerifyMacResponse
  ) extends zio.aws.kms.model.VerifyMacResponse.ReadOnly {
    override val keyId: Optional[KeyIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.keyId())
      .map(value => zio.aws.kms.model.primitives.KeyIdType(value))
    override val macValid: Optional[BooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.macValid())
      .map(value => zio.aws.kms.model.primitives.BooleanType(value))
    override val macAlgorithm: Optional[zio.aws.kms.model.MacAlgorithmSpec] =
      zio.aws.core.internal
        .optionalFromNullable(impl.macAlgorithm())
        .map(value => zio.aws.kms.model.MacAlgorithmSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.VerifyMacResponse
  ): zio.aws.kms.model.VerifyMacResponse.ReadOnly = new Wrapper(impl)
}
