package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  XksProxyVpcEndpointServiceNameType,
  XksProxyUriPathType,
  XksProxyUriEndpointType,
  XksProxyAuthenticationAccessKeyIdType
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class XksProxyConfigurationType(
    connectivity: Optional[zio.aws.kms.model.XksProxyConnectivityType] =
      Optional.Absent,
    accessKeyId: Optional[XksProxyAuthenticationAccessKeyIdType] =
      Optional.Absent,
    uriEndpoint: Optional[XksProxyUriEndpointType] = Optional.Absent,
    uriPath: Optional[XksProxyUriPathType] = Optional.Absent,
    vpcEndpointServiceName: Optional[XksProxyVpcEndpointServiceNameType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.XksProxyConfigurationType = {
    import XksProxyConfigurationType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.XksProxyConfigurationType
      .builder()
      .optionallyWith(connectivity.map(value => value.unwrap))(_.connectivity)
      .optionallyWith(
        accessKeyId.map(value =>
          XksProxyAuthenticationAccessKeyIdType.unwrap(value): java.lang.String
        )
      )(_.accessKeyId)
      .optionallyWith(
        uriEndpoint.map(value =>
          XksProxyUriEndpointType.unwrap(value): java.lang.String
        )
      )(_.uriEndpoint)
      .optionallyWith(
        uriPath.map(value =>
          XksProxyUriPathType.unwrap(value): java.lang.String
        )
      )(_.uriPath)
      .optionallyWith(
        vpcEndpointServiceName.map(value =>
          XksProxyVpcEndpointServiceNameType.unwrap(value): java.lang.String
        )
      )(_.vpcEndpointServiceName)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.XksProxyConfigurationType.ReadOnly =
    zio.aws.kms.model.XksProxyConfigurationType.wrap(buildAwsValue())
}
object XksProxyConfigurationType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.XksProxyConfigurationType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.XksProxyConfigurationType =
      zio.aws.kms.model.XksProxyConfigurationType(
        connectivity.map(value => value),
        accessKeyId.map(value => value),
        uriEndpoint.map(value => value),
        uriPath.map(value => value),
        vpcEndpointServiceName.map(value => value)
      )
    def connectivity: Optional[zio.aws.kms.model.XksProxyConnectivityType]
    def accessKeyId: Optional[XksProxyAuthenticationAccessKeyIdType]
    def uriEndpoint: Optional[XksProxyUriEndpointType]
    def uriPath: Optional[XksProxyUriPathType]
    def vpcEndpointServiceName: Optional[XksProxyVpcEndpointServiceNameType]
    def getConnectivity
        : ZIO[Any, AwsError, zio.aws.kms.model.XksProxyConnectivityType] =
      AwsError.unwrapOptionField("connectivity", connectivity)
    def getAccessKeyId
        : ZIO[Any, AwsError, XksProxyAuthenticationAccessKeyIdType] =
      AwsError.unwrapOptionField("accessKeyId", accessKeyId)
    def getUriEndpoint: ZIO[Any, AwsError, XksProxyUriEndpointType] =
      AwsError.unwrapOptionField("uriEndpoint", uriEndpoint)
    def getUriPath: ZIO[Any, AwsError, XksProxyUriPathType] =
      AwsError.unwrapOptionField("uriPath", uriPath)
    def getVpcEndpointServiceName
        : ZIO[Any, AwsError, XksProxyVpcEndpointServiceNameType] = AwsError
      .unwrapOptionField("vpcEndpointServiceName", vpcEndpointServiceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.XksProxyConfigurationType
  ) extends zio.aws.kms.model.XksProxyConfigurationType.ReadOnly {
    override val connectivity
        : Optional[zio.aws.kms.model.XksProxyConnectivityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectivity())
        .map(value => zio.aws.kms.model.XksProxyConnectivityType.wrap(value))
    override val accessKeyId: Optional[XksProxyAuthenticationAccessKeyIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessKeyId())
        .map(value =>
          zio.aws.kms.model.primitives
            .XksProxyAuthenticationAccessKeyIdType(value)
        )
    override val uriEndpoint: Optional[XksProxyUriEndpointType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uriEndpoint())
        .map(value =>
          zio.aws.kms.model.primitives.XksProxyUriEndpointType(value)
        )
    override val uriPath: Optional[XksProxyUriPathType] = zio.aws.core.internal
      .optionalFromNullable(impl.uriPath())
      .map(value => zio.aws.kms.model.primitives.XksProxyUriPathType(value))
    override val vpcEndpointServiceName
        : Optional[XksProxyVpcEndpointServiceNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointServiceName())
      .map(value =>
        zio.aws.kms.model.primitives.XksProxyVpcEndpointServiceNameType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.XksProxyConfigurationType
  ): zio.aws.kms.model.XksProxyConfigurationType.ReadOnly = new Wrapper(impl)
}
