package zio.aws.kms.model
import scala.jdk.CollectionConverters._
sealed trait XksProxyConnectivityType {
  def unwrap: software.amazon.awssdk.services.kms.model.XksProxyConnectivityType
}
object XksProxyConnectivityType {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.XksProxyConnectivityType
  ): zio.aws.kms.model.XksProxyConnectivityType = value match {
    case software.amazon.awssdk.services.kms.model.XksProxyConnectivityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.XksProxyConnectivityType.PUBLIC_ENDPOINT =>
      val r = PUBLIC_ENDPOINT
      r
    case software.amazon.awssdk.services.kms.model.XksProxyConnectivityType.VPC_ENDPOINT_SERVICE =>
      val r = VPC_ENDPOINT_SERVICE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kms.model.XksProxyConnectivityType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.XksProxyConnectivityType =
      software.amazon.awssdk.services.kms.model.XksProxyConnectivityType.UNKNOWN_TO_SDK_VERSION
  }
  case object PUBLIC_ENDPOINT
      extends zio.aws.kms.model.XksProxyConnectivityType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.XksProxyConnectivityType =
      software.amazon.awssdk.services.kms.model.XksProxyConnectivityType.PUBLIC_ENDPOINT
  }
  case object VPC_ENDPOINT_SERVICE
      extends zio.aws.kms.model.XksProxyConnectivityType {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.XksProxyConnectivityType =
      software.amazon.awssdk.services.kms.model.XksProxyConnectivityType.VPC_ENDPOINT_SERVICE
  }
}
