package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{
  SourceOwner,
  Action,
  StatementId,
  Arn,
  FunctionName,
  Qualifier,
  Principal,
  EventSourceToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AddPermissionRequest(
    functionName: FunctionName,
    statementId: StatementId,
    action: Action,
    principal: Principal,
    sourceArn: Option[Arn] = None,
    sourceAccount: Option[SourceOwner] = None,
    eventSourceToken: Option[EventSourceToken] = None,
    qualifier: Option[Qualifier] = None,
    revisionId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.AddPermissionRequest = {
    import AddPermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.AddPermissionRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .statementId(StatementId.unwrap(statementId): java.lang.String)
      .action(Action.unwrap(action): java.lang.String)
      .principal(Principal.unwrap(principal): java.lang.String)
      .optionallyWith(
        sourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.sourceArn)
      .optionallyWith(
        sourceAccount.map(value => SourceOwner.unwrap(value): java.lang.String)
      )(_.sourceAccount)
      .optionallyWith(
        eventSourceToken.map(value =>
          EventSourceToken.unwrap(value): java.lang.String
        )
      )(_.eventSourceToken)
      .optionallyWith(
        qualifier.map(value => Qualifier.unwrap(value): java.lang.String)
      )(_.qualifier)
      .optionallyWith(revisionId.map(value => value: java.lang.String))(
        _.revisionId
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.AddPermissionRequest.ReadOnly =
    zio.aws.lambda.model.AddPermissionRequest.wrap(buildAwsValue())
}
object AddPermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.AddPermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.AddPermissionRequest =
      zio.aws.lambda.model.AddPermissionRequest(
        functionName,
        statementId,
        action,
        principal,
        sourceArn.map(value => value),
        sourceAccount.map(value => value),
        eventSourceToken.map(value => value),
        qualifier.map(value => value),
        revisionId.map(value => value)
      )
    def functionName: FunctionName
    def statementId: StatementId
    def action: Action
    def principal: Principal
    def sourceArn: Option[Arn]
    def sourceAccount: Option[SourceOwner]
    def eventSourceToken: Option[EventSourceToken]
    def qualifier: Option[Qualifier]
    def revisionId: Option[String]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getStatementId: ZIO[Any, Nothing, StatementId] =
      ZIO.succeed(statementId)
    def getAction: ZIO[Any, Nothing, Action] = ZIO.succeed(action)
    def getPrincipal: ZIO[Any, Nothing, Principal] = ZIO.succeed(principal)
    def getSourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getSourceAccount: ZIO[Any, AwsError, SourceOwner] =
      AwsError.unwrapOptionField("sourceAccount", sourceAccount)
    def getEventSourceToken: ZIO[Any, AwsError, EventSourceToken] =
      AwsError.unwrapOptionField("eventSourceToken", eventSourceToken)
    def getQualifier: ZIO[Any, AwsError, Qualifier] =
      AwsError.unwrapOptionField("qualifier", qualifier)
    def getRevisionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.AddPermissionRequest
  ) extends zio.aws.lambda.model.AddPermissionRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val statementId: StatementId =
      zio.aws.lambda.model.primitives.StatementId(impl.statementId())
    override val action: Action =
      zio.aws.lambda.model.primitives.Action(impl.action())
    override val principal: Principal =
      zio.aws.lambda.model.primitives.Principal(impl.principal())
    override val sourceArn: Option[Arn] = scala
      .Option(impl.sourceArn())
      .map(value => zio.aws.lambda.model.primitives.Arn(value))
    override val sourceAccount: Option[SourceOwner] = scala
      .Option(impl.sourceAccount())
      .map(value => zio.aws.lambda.model.primitives.SourceOwner(value))
    override val eventSourceToken: Option[EventSourceToken] = scala
      .Option(impl.eventSourceToken())
      .map(value => zio.aws.lambda.model.primitives.EventSourceToken(value))
    override val qualifier: Option[Qualifier] = scala
      .Option(impl.qualifier())
      .map(value => zio.aws.lambda.model.primitives.Qualifier(value))
    override val revisionId: Option[String] =
      scala.Option(impl.revisionId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.AddPermissionRequest
  ): zio.aws.lambda.model.AddPermissionRequest.ReadOnly = new Wrapper(impl)
}
