package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AddPermissionResponse(statement: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.AddPermissionResponse = {
    import AddPermissionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.AddPermissionResponse
      .builder()
      .optionallyWith(statement.map(value => value: java.lang.String))(
        _.statement
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.AddPermissionResponse.ReadOnly =
    zio.aws.lambda.model.AddPermissionResponse.wrap(buildAwsValue())
}
object AddPermissionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.AddPermissionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.AddPermissionResponse =
      zio.aws.lambda.model.AddPermissionResponse(statement.map(value => value))
    def statement: Option[String]
    def getStatement: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statement", statement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.AddPermissionResponse
  ) extends zio.aws.lambda.model.AddPermissionResponse.ReadOnly {
    override val statement: Option[String] =
      scala.Option(impl.statement()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.AddPermissionResponse
  ): zio.aws.lambda.model.AddPermissionResponse.ReadOnly = new Wrapper(impl)
}
