package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{
  Description,
  Version,
  Alias,
  FunctionArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateAliasResponse(
    aliasArn: Option[FunctionArn] = None,
    name: Option[Alias] = None,
    functionVersion: Option[Version] = None,
    description: Option[Description] = None,
    routingConfig: Option[zio.aws.lambda.model.AliasRoutingConfiguration] =
      None,
    revisionId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.CreateAliasResponse = {
    import CreateAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.CreateAliasResponse
      .builder()
      .optionallyWith(
        aliasArn.map(value => FunctionArn.unwrap(value): java.lang.String)
      )(_.aliasArn)
      .optionallyWith(name.map(value => Alias.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        functionVersion.map(value => Version.unwrap(value): java.lang.String)
      )(_.functionVersion)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(routingConfig.map(value => value.buildAwsValue()))(
        _.routingConfig
      )
      .optionallyWith(revisionId.map(value => value: java.lang.String))(
        _.revisionId
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.CreateAliasResponse.ReadOnly =
    zio.aws.lambda.model.CreateAliasResponse.wrap(buildAwsValue())
}
object CreateAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.CreateAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.CreateAliasResponse =
      zio.aws.lambda.model.CreateAliasResponse(
        aliasArn.map(value => value),
        name.map(value => value),
        functionVersion.map(value => value),
        description.map(value => value),
        routingConfig.map(value => value.asEditable),
        revisionId.map(value => value)
      )
    def aliasArn: Option[FunctionArn]
    def name: Option[Alias]
    def functionVersion: Option[Version]
    def description: Option[Description]
    def routingConfig
        : Option[zio.aws.lambda.model.AliasRoutingConfiguration.ReadOnly]
    def revisionId: Option[String]
    def getAliasArn: ZIO[Any, AwsError, FunctionArn] =
      AwsError.unwrapOptionField("aliasArn", aliasArn)
    def getName: ZIO[Any, AwsError, Alias] =
      AwsError.unwrapOptionField("name", name)
    def getFunctionVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("functionVersion", functionVersion)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRoutingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.AliasRoutingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("routingConfig", routingConfig)
    def getRevisionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.CreateAliasResponse
  ) extends zio.aws.lambda.model.CreateAliasResponse.ReadOnly {
    override val aliasArn: Option[FunctionArn] = scala
      .Option(impl.aliasArn())
      .map(value => zio.aws.lambda.model.primitives.FunctionArn(value))
    override val name: Option[Alias] = scala
      .Option(impl.name())
      .map(value => zio.aws.lambda.model.primitives.Alias(value))
    override val functionVersion: Option[Version] = scala
      .Option(impl.functionVersion())
      .map(value => zio.aws.lambda.model.primitives.Version(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lambda.model.primitives.Description(value))
    override val routingConfig
        : Option[zio.aws.lambda.model.AliasRoutingConfiguration.ReadOnly] =
      scala
        .Option(impl.routingConfig())
        .map(value =>
          zio.aws.lambda.model.AliasRoutingConfiguration.wrap(value)
        )
    override val revisionId: Option[String] =
      scala.Option(impl.revisionId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.CreateAliasResponse
  ): zio.aws.lambda.model.CreateAliasResponse.ReadOnly = new Wrapper(impl)
}
