package zio.aws.lambda.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lambda.model.primitives.{
  MaximumRetryAttemptsEventSourceMapping,
  BatchSize,
  BisectBatchOnFunctionError,
  Date,
  MaximumBatchingWindowInSeconds,
  Queue,
  Arn,
  ParallelizationFactor,
  FunctionName,
  Enabled,
  Topic,
  TumblingWindowInSeconds,
  MaximumRecordAgeInSeconds
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateEventSourceMappingRequest(
    eventSourceArn: Option[Arn] = None,
    functionName: FunctionName,
    enabled: Option[Enabled] = None,
    batchSize: Option[BatchSize] = None,
    filterCriteria: Option[zio.aws.lambda.model.FilterCriteria] = None,
    maximumBatchingWindowInSeconds: Option[MaximumBatchingWindowInSeconds] =
      None,
    parallelizationFactor: Option[ParallelizationFactor] = None,
    startingPosition: Option[zio.aws.lambda.model.EventSourcePosition] = None,
    startingPositionTimestamp: Option[Date] = None,
    destinationConfig: Option[zio.aws.lambda.model.DestinationConfig] = None,
    maximumRecordAgeInSeconds: Option[MaximumRecordAgeInSeconds] = None,
    bisectBatchOnFunctionError: Option[BisectBatchOnFunctionError] = None,
    maximumRetryAttempts: Option[MaximumRetryAttemptsEventSourceMapping] = None,
    tumblingWindowInSeconds: Option[TumblingWindowInSeconds] = None,
    topics: Option[Iterable[Topic]] = None,
    queues: Option[Iterable[Queue]] = None,
    sourceAccessConfigurations: Option[
      Iterable[zio.aws.lambda.model.SourceAccessConfiguration]
    ] = None,
    selfManagedEventSource: Option[
      zio.aws.lambda.model.SelfManagedEventSource
    ] = None,
    functionResponseTypes: Option[
      Iterable[zio.aws.lambda.model.FunctionResponseType]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest = {
    import CreateEventSourceMappingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest
      .builder()
      .optionallyWith(
        eventSourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.eventSourceArn)
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(batchSize.map(value => BatchSize.unwrap(value): Integer))(
        _.batchSize
      )
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .optionallyWith(
        maximumBatchingWindowInSeconds.map(value =>
          MaximumBatchingWindowInSeconds.unwrap(value): Integer
        )
      )(_.maximumBatchingWindowInSeconds)
      .optionallyWith(
        parallelizationFactor.map(value =>
          ParallelizationFactor.unwrap(value): Integer
        )
      )(_.parallelizationFactor)
      .optionallyWith(startingPosition.map(value => value.unwrap))(
        _.startingPosition
      )
      .optionallyWith(
        startingPositionTimestamp.map(value => Date.unwrap(value): Instant)
      )(_.startingPositionTimestamp)
      .optionallyWith(destinationConfig.map(value => value.buildAwsValue()))(
        _.destinationConfig
      )
      .optionallyWith(
        maximumRecordAgeInSeconds.map(value =>
          MaximumRecordAgeInSeconds.unwrap(value): Integer
        )
      )(_.maximumRecordAgeInSeconds)
      .optionallyWith(
        bisectBatchOnFunctionError.map(value =>
          BisectBatchOnFunctionError.unwrap(value): java.lang.Boolean
        )
      )(_.bisectBatchOnFunctionError)
      .optionallyWith(
        maximumRetryAttempts.map(value =>
          MaximumRetryAttemptsEventSourceMapping.unwrap(value): Integer
        )
      )(_.maximumRetryAttempts)
      .optionallyWith(
        tumblingWindowInSeconds.map(value =>
          TumblingWindowInSeconds.unwrap(value): Integer
        )
      )(_.tumblingWindowInSeconds)
      .optionallyWith(
        topics.map(value =>
          value.map { item =>
            Topic.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.topics)
      .optionallyWith(
        queues.map(value =>
          value.map { item =>
            Queue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.queues)
      .optionallyWith(
        sourceAccessConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceAccessConfigurations)
      .optionallyWith(
        selfManagedEventSource.map(value => value.buildAwsValue())
      )(_.selfManagedEventSource)
      .optionallyWith(
        functionResponseTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.functionResponseTypesWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.CreateEventSourceMappingRequest.ReadOnly =
    zio.aws.lambda.model.CreateEventSourceMappingRequest.wrap(buildAwsValue())
}
object CreateEventSourceMappingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.CreateEventSourceMappingRequest =
      zio.aws.lambda.model.CreateEventSourceMappingRequest(
        eventSourceArn.map(value => value),
        functionName,
        enabled.map(value => value),
        batchSize.map(value => value),
        filterCriteria.map(value => value.asEditable),
        maximumBatchingWindowInSeconds.map(value => value),
        parallelizationFactor.map(value => value),
        startingPosition.map(value => value),
        startingPositionTimestamp.map(value => value),
        destinationConfig.map(value => value.asEditable),
        maximumRecordAgeInSeconds.map(value => value),
        bisectBatchOnFunctionError.map(value => value),
        maximumRetryAttempts.map(value => value),
        tumblingWindowInSeconds.map(value => value),
        topics.map(value => value),
        queues.map(value => value),
        sourceAccessConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        selfManagedEventSource.map(value => value.asEditable),
        functionResponseTypes.map(value => value)
      )
    def eventSourceArn: Option[Arn]
    def functionName: FunctionName
    def enabled: Option[Enabled]
    def batchSize: Option[BatchSize]
    def filterCriteria: Option[zio.aws.lambda.model.FilterCriteria.ReadOnly]
    def maximumBatchingWindowInSeconds: Option[MaximumBatchingWindowInSeconds]
    def parallelizationFactor: Option[ParallelizationFactor]
    def startingPosition: Option[zio.aws.lambda.model.EventSourcePosition]
    def startingPositionTimestamp: Option[Date]
    def destinationConfig
        : Option[zio.aws.lambda.model.DestinationConfig.ReadOnly]
    def maximumRecordAgeInSeconds: Option[MaximumRecordAgeInSeconds]
    def bisectBatchOnFunctionError: Option[BisectBatchOnFunctionError]
    def maximumRetryAttempts: Option[MaximumRetryAttemptsEventSourceMapping]
    def tumblingWindowInSeconds: Option[TumblingWindowInSeconds]
    def topics: Option[List[Topic]]
    def queues: Option[List[Queue]]
    def sourceAccessConfigurations
        : Option[List[zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly]]
    def selfManagedEventSource
        : Option[zio.aws.lambda.model.SelfManagedEventSource.ReadOnly]
    def functionResponseTypes
        : Option[List[zio.aws.lambda.model.FunctionResponseType]]
    def getEventSourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("eventSourceArn", eventSourceArn)
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getBatchSize: ZIO[Any, AwsError, BatchSize] =
      AwsError.unwrapOptionField("batchSize", batchSize)
    def getFilterCriteria
        : ZIO[Any, AwsError, zio.aws.lambda.model.FilterCriteria.ReadOnly] =
      AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getMaximumBatchingWindowInSeconds
        : ZIO[Any, AwsError, MaximumBatchingWindowInSeconds] =
      AwsError.unwrapOptionField(
        "maximumBatchingWindowInSeconds",
        maximumBatchingWindowInSeconds
      )
    def getParallelizationFactor: ZIO[Any, AwsError, ParallelizationFactor] =
      AwsError.unwrapOptionField("parallelizationFactor", parallelizationFactor)
    def getStartingPosition
        : ZIO[Any, AwsError, zio.aws.lambda.model.EventSourcePosition] =
      AwsError.unwrapOptionField("startingPosition", startingPosition)
    def getStartingPositionTimestamp: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("startingPositionTimestamp", startingPositionTimestamp)
    def getDestinationConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.DestinationConfig.ReadOnly] =
      AwsError.unwrapOptionField("destinationConfig", destinationConfig)
    def getMaximumRecordAgeInSeconds
        : ZIO[Any, AwsError, MaximumRecordAgeInSeconds] = AwsError
      .unwrapOptionField("maximumRecordAgeInSeconds", maximumRecordAgeInSeconds)
    def getBisectBatchOnFunctionError
        : ZIO[Any, AwsError, BisectBatchOnFunctionError] =
      AwsError.unwrapOptionField(
        "bisectBatchOnFunctionError",
        bisectBatchOnFunctionError
      )
    def getMaximumRetryAttempts
        : ZIO[Any, AwsError, MaximumRetryAttemptsEventSourceMapping] =
      AwsError.unwrapOptionField("maximumRetryAttempts", maximumRetryAttempts)
    def getTumblingWindowInSeconds
        : ZIO[Any, AwsError, TumblingWindowInSeconds] = AwsError
      .unwrapOptionField("tumblingWindowInSeconds", tumblingWindowInSeconds)
    def getTopics: ZIO[Any, AwsError, List[Topic]] =
      AwsError.unwrapOptionField("topics", topics)
    def getQueues: ZIO[Any, AwsError, List[Queue]] =
      AwsError.unwrapOptionField("queues", queues)
    def getSourceAccessConfigurations: ZIO[Any, AwsError, List[
      zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "sourceAccessConfigurations",
      sourceAccessConfigurations
    )
    def getSelfManagedEventSource: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.SelfManagedEventSource.ReadOnly
    ] = AwsError.unwrapOptionField(
      "selfManagedEventSource",
      selfManagedEventSource
    )
    def getFunctionResponseTypes
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.FunctionResponseType]] =
      AwsError.unwrapOptionField("functionResponseTypes", functionResponseTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest
  ) extends zio.aws.lambda.model.CreateEventSourceMappingRequest.ReadOnly {
    override val eventSourceArn: Option[Arn] = scala
      .Option(impl.eventSourceArn())
      .map(value => zio.aws.lambda.model.primitives.Arn(value))
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val enabled: Option[Enabled] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.lambda.model.primitives.Enabled(value))
    override val batchSize: Option[BatchSize] = scala
      .Option(impl.batchSize())
      .map(value => zio.aws.lambda.model.primitives.BatchSize(value))
    override val filterCriteria
        : Option[zio.aws.lambda.model.FilterCriteria.ReadOnly] = scala
      .Option(impl.filterCriteria())
      .map(value => zio.aws.lambda.model.FilterCriteria.wrap(value))
    override val maximumBatchingWindowInSeconds
        : Option[MaximumBatchingWindowInSeconds] = scala
      .Option(impl.maximumBatchingWindowInSeconds())
      .map(value =>
        zio.aws.lambda.model.primitives.MaximumBatchingWindowInSeconds(value)
      )
    override val parallelizationFactor: Option[ParallelizationFactor] = scala
      .Option(impl.parallelizationFactor())
      .map(value =>
        zio.aws.lambda.model.primitives.ParallelizationFactor(value)
      )
    override val startingPosition
        : Option[zio.aws.lambda.model.EventSourcePosition] = scala
      .Option(impl.startingPosition())
      .map(value => zio.aws.lambda.model.EventSourcePosition.wrap(value))
    override val startingPositionTimestamp: Option[Date] = scala
      .Option(impl.startingPositionTimestamp())
      .map(value => zio.aws.lambda.model.primitives.Date(value))
    override val destinationConfig
        : Option[zio.aws.lambda.model.DestinationConfig.ReadOnly] = scala
      .Option(impl.destinationConfig())
      .map(value => zio.aws.lambda.model.DestinationConfig.wrap(value))
    override val maximumRecordAgeInSeconds: Option[MaximumRecordAgeInSeconds] =
      scala
        .Option(impl.maximumRecordAgeInSeconds())
        .map(value =>
          zio.aws.lambda.model.primitives.MaximumRecordAgeInSeconds(value)
        )
    override val bisectBatchOnFunctionError
        : Option[BisectBatchOnFunctionError] = scala
      .Option(impl.bisectBatchOnFunctionError())
      .map(value =>
        zio.aws.lambda.model.primitives.BisectBatchOnFunctionError(value)
      )
    override val maximumRetryAttempts
        : Option[MaximumRetryAttemptsEventSourceMapping] = scala
      .Option(impl.maximumRetryAttempts())
      .map(value =>
        zio.aws.lambda.model.primitives
          .MaximumRetryAttemptsEventSourceMapping(value)
      )
    override val tumblingWindowInSeconds: Option[TumblingWindowInSeconds] =
      scala
        .Option(impl.tumblingWindowInSeconds())
        .map(value =>
          zio.aws.lambda.model.primitives.TumblingWindowInSeconds(value)
        )
    override val topics: Option[List[Topic]] = scala
      .Option(impl.topics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.Topic(item)
        }.toList
      )
    override val queues: Option[List[Queue]] = scala
      .Option(impl.queues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.Queue(item)
        }.toList
      )
    override val sourceAccessConfigurations: Option[
      List[zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly]
    ] = scala
      .Option(impl.sourceAccessConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.SourceAccessConfiguration.wrap(item)
        }.toList
      )
    override val selfManagedEventSource
        : Option[zio.aws.lambda.model.SelfManagedEventSource.ReadOnly] = scala
      .Option(impl.selfManagedEventSource())
      .map(value => zio.aws.lambda.model.SelfManagedEventSource.wrap(value))
    override val functionResponseTypes
        : Option[List[zio.aws.lambda.model.FunctionResponseType]] = scala
      .Option(impl.functionResponseTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.FunctionResponseType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest
  ): zio.aws.lambda.model.CreateEventSourceMappingRequest.ReadOnly =
    new Wrapper(impl)
}
