package zio.aws.lambda.model
import scala.jdk.CollectionConverters._
sealed trait FunctionVersion {
  def unwrap: software.amazon.awssdk.services.lambda.model.FunctionVersion
}
object FunctionVersion {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.FunctionVersion
  ): zio.aws.lambda.model.FunctionVersion = value match {
    case software.amazon.awssdk.services.lambda.model.FunctionVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.FunctionVersion.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion extends zio.aws.lambda.model.FunctionVersion {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.FunctionVersion =
      software.amazon.awssdk.services.lambda.model.FunctionVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.lambda.model.FunctionVersion {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.FunctionVersion =
      software.amazon.awssdk.services.lambda.model.FunctionVersion.ALL
  }
}
