package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.FunctionName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetFunctionCodeSigningConfigRequest(
    functionName: FunctionName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetFunctionCodeSigningConfigRequest = {
    import GetFunctionCodeSigningConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetFunctionCodeSigningConfigRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.GetFunctionCodeSigningConfigRequest.ReadOnly =
    zio.aws.lambda.model.GetFunctionCodeSigningConfigRequest
      .wrap(buildAwsValue())
}
object GetFunctionCodeSigningConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetFunctionCodeSigningConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetFunctionCodeSigningConfigRequest =
      zio.aws.lambda.model.GetFunctionCodeSigningConfigRequest(functionName)
    def functionName: FunctionName
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionCodeSigningConfigRequest
  ) extends zio.aws.lambda.model.GetFunctionCodeSigningConfigRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionCodeSigningConfigRequest
  ): zio.aws.lambda.model.GetFunctionCodeSigningConfigRequest.ReadOnly =
    new Wrapper(impl)
}
