package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{Qualifier, NamespacedFunctionName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetFunctionConfigurationRequest(
    functionName: NamespacedFunctionName,
    qualifier: Option[Qualifier] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationRequest = {
    import GetFunctionConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationRequest
      .builder()
      .functionName(
        NamespacedFunctionName.unwrap(functionName): java.lang.String
      )
      .optionallyWith(
        qualifier.map(value => Qualifier.unwrap(value): java.lang.String)
      )(_.qualifier)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.GetFunctionConfigurationRequest.ReadOnly =
    zio.aws.lambda.model.GetFunctionConfigurationRequest.wrap(buildAwsValue())
}
object GetFunctionConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetFunctionConfigurationRequest =
      zio.aws.lambda.model.GetFunctionConfigurationRequest(
        functionName,
        qualifier.map(value => value)
      )
    def functionName: NamespacedFunctionName
    def qualifier: Option[Qualifier]
    def getFunctionName: ZIO[Any, Nothing, NamespacedFunctionName] =
      ZIO.succeed(functionName)
    def getQualifier: ZIO[Any, AwsError, Qualifier] =
      AwsError.unwrapOptionField("qualifier", qualifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationRequest
  ) extends zio.aws.lambda.model.GetFunctionConfigurationRequest.ReadOnly {
    override val functionName: NamespacedFunctionName =
      zio.aws.lambda.model.primitives
        .NamespacedFunctionName(impl.functionName())
    override val qualifier: Option[Qualifier] = scala
      .Option(impl.qualifier())
      .map(value => zio.aws.lambda.model.primitives.Qualifier(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationRequest
  ): zio.aws.lambda.model.GetFunctionConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
