package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{LayerVersionNumber, LayerName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetLayerVersionPolicyRequest(
    layerName: LayerName,
    versionNumber: LayerVersionNumber
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyRequest = {
    import GetLayerVersionPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyRequest
      .builder()
      .layerName(LayerName.unwrap(layerName): java.lang.String)
      .versionNumber(LayerVersionNumber.unwrap(versionNumber): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.GetLayerVersionPolicyRequest.ReadOnly =
    zio.aws.lambda.model.GetLayerVersionPolicyRequest.wrap(buildAwsValue())
}
object GetLayerVersionPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetLayerVersionPolicyRequest =
      zio.aws.lambda.model
        .GetLayerVersionPolicyRequest(layerName, versionNumber)
    def layerName: LayerName
    def versionNumber: LayerVersionNumber
    def getLayerName: ZIO[Any, Nothing, LayerName] = ZIO.succeed(layerName)
    def getVersionNumber: ZIO[Any, Nothing, LayerVersionNumber] =
      ZIO.succeed(versionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyRequest
  ) extends zio.aws.lambda.model.GetLayerVersionPolicyRequest.ReadOnly {
    override val layerName: LayerName =
      zio.aws.lambda.model.primitives.LayerName(impl.layerName())
    override val versionNumber: LayerVersionNumber =
      zio.aws.lambda.model.primitives.LayerVersionNumber(impl.versionNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyRequest
  ): zio.aws.lambda.model.GetLayerVersionPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
