package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetPolicyResponse(
    policy: Option[String] = None,
    revisionId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetPolicyResponse = {
    import GetPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetPolicyResponse
      .builder()
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .optionallyWith(revisionId.map(value => value: java.lang.String))(
        _.revisionId
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.GetPolicyResponse.ReadOnly =
    zio.aws.lambda.model.GetPolicyResponse.wrap(buildAwsValue())
}
object GetPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetPolicyResponse =
      zio.aws.lambda.model.GetPolicyResponse(
        policy.map(value => value),
        revisionId.map(value => value)
      )
    def policy: Option[String]
    def revisionId: Option[String]
    def getPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policy", policy)
    def getRevisionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetPolicyResponse
  ) extends zio.aws.lambda.model.GetPolicyResponse.ReadOnly {
    override val policy: Option[String] =
      scala.Option(impl.policy()).map(value => value: String)
    override val revisionId: Option[String] =
      scala.Option(impl.revisionId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetPolicyResponse
  ): zio.aws.lambda.model.GetPolicyResponse.ReadOnly = new Wrapper(impl)
}
