package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.WorkingDirectory
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImageConfig(
    entryPoint: Option[Iterable[String]] = None,
    command: Option[Iterable[String]] = None,
    workingDirectory: Option[WorkingDirectory] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ImageConfig = {
    import ImageConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ImageConfig
      .builder()
      .optionallyWith(
        entryPoint.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.entryPoint)
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .optionallyWith(
        workingDirectory.map(value =>
          WorkingDirectory.unwrap(value): java.lang.String
        )
      )(_.workingDirectory)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ImageConfig.ReadOnly =
    zio.aws.lambda.model.ImageConfig.wrap(buildAwsValue())
}
object ImageConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ImageConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ImageConfig =
      zio.aws.lambda.model.ImageConfig(
        entryPoint.map(value => value),
        command.map(value => value),
        workingDirectory.map(value => value)
      )
    def entryPoint: Option[List[String]]
    def command: Option[List[String]]
    def workingDirectory: Option[WorkingDirectory]
    def getEntryPoint: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("entryPoint", entryPoint)
    def getCommand: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("command", command)
    def getWorkingDirectory: ZIO[Any, AwsError, WorkingDirectory] =
      AwsError.unwrapOptionField("workingDirectory", workingDirectory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ImageConfig
  ) extends zio.aws.lambda.model.ImageConfig.ReadOnly {
    override val entryPoint: Option[List[String]] = scala
      .Option(impl.entryPoint())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val command: Option[List[String]] = scala
      .Option(impl.command())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val workingDirectory: Option[WorkingDirectory] = scala
      .Option(impl.workingDirectory())
      .map(value => zio.aws.lambda.model.primitives.WorkingDirectory(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ImageConfig
  ): zio.aws.lambda.model.ImageConfig.ReadOnly = new Wrapper(impl)
}
