package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{Version, Blob, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InvokeResponse(
    statusCode: Option[Integer] = None,
    functionError: Option[String] = None,
    logResult: Option[String] = None,
    payload: Option[Blob] = None,
    executedVersion: Option[Version] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.InvokeResponse = {
    import InvokeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.InvokeResponse
      .builder()
      .optionallyWith(
        statusCode.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.statusCode)
      .optionallyWith(functionError.map(value => value: java.lang.String))(
        _.functionError
      )
      .optionallyWith(logResult.map(value => value: java.lang.String))(
        _.logResult
      )
      .optionallyWith(
        payload.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.payload)
      .optionallyWith(
        executedVersion.map(value => Version.unwrap(value): java.lang.String)
      )(_.executedVersion)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.InvokeResponse.ReadOnly =
    zio.aws.lambda.model.InvokeResponse.wrap(buildAwsValue())
}
object InvokeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.InvokeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.InvokeResponse =
      zio.aws.lambda.model.InvokeResponse(
        statusCode.map(value => value),
        functionError.map(value => value),
        logResult.map(value => value),
        payload.map(value => value),
        executedVersion.map(value => value)
      )
    def statusCode: Option[Integer]
    def functionError: Option[String]
    def logResult: Option[String]
    def payload: Option[Blob]
    def executedVersion: Option[Version]
    def getStatusCode: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getFunctionError: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("functionError", functionError)
    def getLogResult: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logResult", logResult)
    def getPayload: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("payload", payload)
    def getExecutedVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("executedVersion", executedVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.InvokeResponse
  ) extends zio.aws.lambda.model.InvokeResponse.ReadOnly {
    override val statusCode: Option[Integer] = scala
      .Option(impl.statusCode())
      .map(value => zio.aws.lambda.model.primitives.Integer(value))
    override val functionError: Option[String] =
      scala.Option(impl.functionError()).map(value => value: String)
    override val logResult: Option[String] =
      scala.Option(impl.logResult()).map(value => value: String)
    override val payload: Option[Blob] = scala
      .Option(impl.payload())
      .map(value =>
        zio.aws.lambda.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val executedVersion: Option[Version] = scala
      .Option(impl.executedVersion())
      .map(value => zio.aws.lambda.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.InvokeResponse
  ): zio.aws.lambda.model.InvokeResponse.ReadOnly = new Wrapper(impl)
}
