package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAliasesResponse(
    nextMarker: Option[String] = None,
    aliases: Option[Iterable[zio.aws.lambda.model.AliasConfiguration]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListAliasesResponse = {
    import ListAliasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListAliasesResponse
      .builder()
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .optionallyWith(
        aliases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aliases)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ListAliasesResponse.ReadOnly =
    zio.aws.lambda.model.ListAliasesResponse.wrap(buildAwsValue())
}
object ListAliasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListAliasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ListAliasesResponse =
      zio.aws.lambda.model.ListAliasesResponse(
        nextMarker.map(value => value),
        aliases.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Option[String]
    def aliases: Option[List[zio.aws.lambda.model.AliasConfiguration.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getAliases: ZIO[Any, AwsError, List[
      zio.aws.lambda.model.AliasConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("aliases", aliases)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListAliasesResponse
  ) extends zio.aws.lambda.model.ListAliasesResponse.ReadOnly {
    override val nextMarker: Option[String] =
      scala.Option(impl.nextMarker()).map(value => value: String)
    override val aliases
        : Option[List[zio.aws.lambda.model.AliasConfiguration.ReadOnly]] = scala
      .Option(impl.aliases())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.AliasConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListAliasesResponse
  ): zio.aws.lambda.model.ListAliasesResponse.ReadOnly = new Wrapper(impl)
}
