package zio.aws.lambda.model
import java.lang.Integer
import zio.aws.lambda.model.primitives.MaxListItems
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListCodeSigningConfigsRequest(
    marker: Option[String] = None,
    maxItems: Option[MaxListItems] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest = {
    import ListCodeSigningConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxListItems.unwrap(value): Integer)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ListCodeSigningConfigsRequest.ReadOnly =
    zio.aws.lambda.model.ListCodeSigningConfigsRequest.wrap(buildAwsValue())
}
object ListCodeSigningConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ListCodeSigningConfigsRequest =
      zio.aws.lambda.model.ListCodeSigningConfigsRequest(
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def marker: Option[String]
    def maxItems: Option[MaxListItems]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxListItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest
  ) extends zio.aws.lambda.model.ListCodeSigningConfigsRequest.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxItems: Option[MaxListItems] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.lambda.model.primitives.MaxListItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListCodeSigningConfigsRequest
  ): zio.aws.lambda.model.ListCodeSigningConfigsRequest.ReadOnly = new Wrapper(
    impl
  )
}
