package zio.aws.lambda.model
import java.lang.Integer
import zio.aws.lambda.model.primitives.{
  MaxFunctionEventInvokeConfigListItems,
  FunctionName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListFunctionEventInvokeConfigsRequest(
    functionName: FunctionName,
    marker: Option[String] = None,
    maxItems: Option[MaxFunctionEventInvokeConfigListItems] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest = {
    import ListFunctionEventInvokeConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxItems.map(value =>
          MaxFunctionEventInvokeConfigListItems.unwrap(value): Integer
        )
      )(_.maxItems)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.ListFunctionEventInvokeConfigsRequest.ReadOnly =
    zio.aws.lambda.model.ListFunctionEventInvokeConfigsRequest
      .wrap(buildAwsValue())
}
object ListFunctionEventInvokeConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ListFunctionEventInvokeConfigsRequest =
      zio.aws.lambda.model.ListFunctionEventInvokeConfigsRequest(
        functionName,
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def functionName: FunctionName
    def marker: Option[String]
    def maxItems: Option[MaxFunctionEventInvokeConfigListItems]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxFunctionEventInvokeConfigListItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest
  ) extends zio.aws.lambda.model.ListFunctionEventInvokeConfigsRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxItems: Option[MaxFunctionEventInvokeConfigListItems] = scala
      .Option(impl.maxItems())
      .map(value =>
        zio.aws.lambda.model.primitives
          .MaxFunctionEventInvokeConfigListItems(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest
  ): zio.aws.lambda.model.ListFunctionEventInvokeConfigsRequest.ReadOnly =
    new Wrapper(impl)
}
