package zio.aws.lambda.model
import java.lang.Integer
import zio.aws.lambda.model.primitives.{MaxLayerListItems, LayerName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListLayerVersionsRequest(
    compatibleRuntime: Option[zio.aws.lambda.model.Runtime] = None,
    layerName: LayerName,
    marker: Option[String] = None,
    maxItems: Option[MaxLayerListItems] = None,
    compatibleArchitecture: Option[zio.aws.lambda.model.Architecture] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest = {
    import ListLayerVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest
      .builder()
      .optionallyWith(compatibleRuntime.map(value => value.unwrap))(
        _.compatibleRuntime
      )
      .layerName(LayerName.unwrap(layerName): java.lang.String)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxLayerListItems.unwrap(value): Integer)
      )(_.maxItems)
      .optionallyWith(compatibleArchitecture.map(value => value.unwrap))(
        _.compatibleArchitecture
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ListLayerVersionsRequest.ReadOnly =
    zio.aws.lambda.model.ListLayerVersionsRequest.wrap(buildAwsValue())
}
object ListLayerVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ListLayerVersionsRequest =
      zio.aws.lambda.model.ListLayerVersionsRequest(
        compatibleRuntime.map(value => value),
        layerName,
        marker.map(value => value),
        maxItems.map(value => value),
        compatibleArchitecture.map(value => value)
      )
    def compatibleRuntime: Option[zio.aws.lambda.model.Runtime]
    def layerName: LayerName
    def marker: Option[String]
    def maxItems: Option[MaxLayerListItems]
    def compatibleArchitecture: Option[zio.aws.lambda.model.Architecture]
    def getCompatibleRuntime: ZIO[Any, AwsError, zio.aws.lambda.model.Runtime] =
      AwsError.unwrapOptionField("compatibleRuntime", compatibleRuntime)
    def getLayerName: ZIO[Any, Nothing, LayerName] = ZIO.succeed(layerName)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxLayerListItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getCompatibleArchitecture
        : ZIO[Any, AwsError, zio.aws.lambda.model.Architecture] = AwsError
      .unwrapOptionField("compatibleArchitecture", compatibleArchitecture)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest
  ) extends zio.aws.lambda.model.ListLayerVersionsRequest.ReadOnly {
    override val compatibleRuntime: Option[zio.aws.lambda.model.Runtime] = scala
      .Option(impl.compatibleRuntime())
      .map(value => zio.aws.lambda.model.Runtime.wrap(value))
    override val layerName: LayerName =
      zio.aws.lambda.model.primitives.LayerName(impl.layerName())
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val maxItems: Option[MaxLayerListItems] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.lambda.model.primitives.MaxLayerListItems(value))
    override val compatibleArchitecture
        : Option[zio.aws.lambda.model.Architecture] = scala
      .Option(impl.compatibleArchitecture())
      .map(value => zio.aws.lambda.model.Architecture.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest
  ): zio.aws.lambda.model.ListLayerVersionsRequest.ReadOnly = new Wrapper(impl)
}
