package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{Description, FunctionName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PublishVersionRequest(
    functionName: FunctionName,
    codeSha256: Option[String] = None,
    description: Option[Description] = None,
    revisionId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.PublishVersionRequest = {
    import PublishVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.PublishVersionRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(codeSha256.map(value => value: java.lang.String))(
        _.codeSha256
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(revisionId.map(value => value: java.lang.String))(
        _.revisionId
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.PublishVersionRequest.ReadOnly =
    zio.aws.lambda.model.PublishVersionRequest.wrap(buildAwsValue())
}
object PublishVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.PublishVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.PublishVersionRequest =
      zio.aws.lambda.model.PublishVersionRequest(
        functionName,
        codeSha256.map(value => value),
        description.map(value => value),
        revisionId.map(value => value)
      )
    def functionName: FunctionName
    def codeSha256: Option[String]
    def description: Option[Description]
    def revisionId: Option[String]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getCodeSha256: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("codeSha256", codeSha256)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRevisionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.PublishVersionRequest
  ) extends zio.aws.lambda.model.PublishVersionRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val codeSha256: Option[String] =
      scala.Option(impl.codeSha256()).map(value => value: String)
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lambda.model.primitives.Description(value))
    override val revisionId: Option[String] =
      scala.Option(impl.revisionId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.PublishVersionRequest
  ): zio.aws.lambda.model.PublishVersionRequest.ReadOnly = new Wrapper(impl)
}
