package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.URI
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SourceAccessConfiguration(
    `type`: Option[zio.aws.lambda.model.SourceAccessType] = None,
    uri: Option[URI] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.SourceAccessConfiguration = {
    import SourceAccessConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.SourceAccessConfiguration
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(uri.map(value => URI.unwrap(value): java.lang.String))(
        _.uri
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly =
    zio.aws.lambda.model.SourceAccessConfiguration.wrap(buildAwsValue())
}
object SourceAccessConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.SourceAccessConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.SourceAccessConfiguration =
      zio.aws.lambda.model.SourceAccessConfiguration(
        `type`.map(value => value),
        uri.map(value => value)
      )
    def `type`: Option[zio.aws.lambda.model.SourceAccessType]
    def uri: Option[URI]
    def getType: ZIO[Any, AwsError, zio.aws.lambda.model.SourceAccessType] =
      AwsError.unwrapOptionField("type", `type`)
    def getUri: ZIO[Any, AwsError, URI] = AwsError.unwrapOptionField("uri", uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.SourceAccessConfiguration
  ) extends zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly {
    override val `type`: Option[zio.aws.lambda.model.SourceAccessType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.lambda.model.SourceAccessType.wrap(value))
    override val uri: Option[URI] = scala
      .Option(impl.uri())
      .map(value => zio.aws.lambda.model.primitives.URI(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.SourceAccessConfiguration
  ): zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly = new Wrapper(impl)
}
