package zio.aws.lambda.model
import scala.jdk.CollectionConverters._
sealed trait SourceAccessType {
  def unwrap: software.amazon.awssdk.services.lambda.model.SourceAccessType
}
object SourceAccessType {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.SourceAccessType
  ): zio.aws.lambda.model.SourceAccessType = value match {
    case software.amazon.awssdk.services.lambda.model.SourceAccessType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.SourceAccessType.BASIC_AUTH =>
      val r = BASIC_AUTH
      r
    case software.amazon.awssdk.services.lambda.model.SourceAccessType.VPC_SUBNET =>
      val r = VPC_SUBNET
      r
    case software.amazon.awssdk.services.lambda.model.SourceAccessType.VPC_SECURITY_GROUP =>
      val r = VPC_SECURITY_GROUP
      r
    case software.amazon.awssdk.services.lambda.model.SourceAccessType.SASL_SCRAM_512_AUTH =>
      val r = SASL_SCRAM_512_AUTH
      r
    case software.amazon.awssdk.services.lambda.model.SourceAccessType.SASL_SCRAM_256_AUTH =>
      val r = SASL_SCRAM_256_AUTH
      r
    case software.amazon.awssdk.services.lambda.model.SourceAccessType.VIRTUAL_HOST =>
      val r = VIRTUAL_HOST
      r
    case software.amazon.awssdk.services.lambda.model.SourceAccessType.CLIENT_CERTIFICATE_TLS_AUTH =>
      val r = CLIENT_CERTIFICATE_TLS_AUTH
      r
    case software.amazon.awssdk.services.lambda.model.SourceAccessType.SERVER_ROOT_CA_CERTIFICATE =>
      val r = SERVER_ROOT_CA_CERTIFICATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lambda.model.SourceAccessType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.SourceAccessType =
      software.amazon.awssdk.services.lambda.model.SourceAccessType.UNKNOWN_TO_SDK_VERSION
  }
  case object BASIC_AUTH extends zio.aws.lambda.model.SourceAccessType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.SourceAccessType =
      software.amazon.awssdk.services.lambda.model.SourceAccessType.BASIC_AUTH
  }
  case object VPC_SUBNET extends zio.aws.lambda.model.SourceAccessType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.SourceAccessType =
      software.amazon.awssdk.services.lambda.model.SourceAccessType.VPC_SUBNET
  }
  case object VPC_SECURITY_GROUP extends zio.aws.lambda.model.SourceAccessType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.SourceAccessType =
      software.amazon.awssdk.services.lambda.model.SourceAccessType.VPC_SECURITY_GROUP
  }
  case object SASL_SCRAM_512_AUTH
      extends zio.aws.lambda.model.SourceAccessType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.SourceAccessType =
      software.amazon.awssdk.services.lambda.model.SourceAccessType.SASL_SCRAM_512_AUTH
  }
  case object SASL_SCRAM_256_AUTH
      extends zio.aws.lambda.model.SourceAccessType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.SourceAccessType =
      software.amazon.awssdk.services.lambda.model.SourceAccessType.SASL_SCRAM_256_AUTH
  }
  case object VIRTUAL_HOST extends zio.aws.lambda.model.SourceAccessType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.SourceAccessType =
      software.amazon.awssdk.services.lambda.model.SourceAccessType.VIRTUAL_HOST
  }
  case object CLIENT_CERTIFICATE_TLS_AUTH
      extends zio.aws.lambda.model.SourceAccessType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.SourceAccessType =
      software.amazon.awssdk.services.lambda.model.SourceAccessType.CLIENT_CERTIFICATE_TLS_AUTH
  }
  case object SERVER_ROOT_CA_CERTIFICATE
      extends zio.aws.lambda.model.SourceAccessType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.SourceAccessType =
      software.amazon.awssdk.services.lambda.model.SourceAccessType.SERVER_ROOT_CA_CERTIFICATE
  }
}
