package zio.aws.lambda.model
import scala.jdk.CollectionConverters._
sealed trait State {
  def unwrap: software.amazon.awssdk.services.lambda.model.State
}
object State {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.State
  ): zio.aws.lambda.model.State = value match {
    case software.amazon.awssdk.services.lambda.model.State.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.State.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.lambda.model.State.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.lambda.model.State.INACTIVE =>
      val r = Inactive
      r
    case software.amazon.awssdk.services.lambda.model.State.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion extends zio.aws.lambda.model.State {
    override def unwrap: software.amazon.awssdk.services.lambda.model.State =
      software.amazon.awssdk.services.lambda.model.State.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.lambda.model.State {
    override def unwrap: software.amazon.awssdk.services.lambda.model.State =
      software.amazon.awssdk.services.lambda.model.State.PENDING
  }
  case object Active extends zio.aws.lambda.model.State {
    override def unwrap: software.amazon.awssdk.services.lambda.model.State =
      software.amazon.awssdk.services.lambda.model.State.ACTIVE
  }
  case object Inactive extends zio.aws.lambda.model.State {
    override def unwrap: software.amazon.awssdk.services.lambda.model.State =
      software.amazon.awssdk.services.lambda.model.State.INACTIVE
  }
  case object Failed extends zio.aws.lambda.model.State {
    override def unwrap: software.amazon.awssdk.services.lambda.model.State =
      software.amazon.awssdk.services.lambda.model.State.FAILED
  }
}
