package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{VpcId, SecurityGroupId, SubnetId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VpcConfigResponse(
    subnetIds: Option[Iterable[SubnetId]] = None,
    securityGroupIds: Option[Iterable[SecurityGroupId]] = None,
    vpcId: Option[VpcId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.VpcConfigResponse = {
    import VpcConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.VpcConfigResponse
      .builder()
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.VpcConfigResponse.ReadOnly =
    zio.aws.lambda.model.VpcConfigResponse.wrap(buildAwsValue())
}
object VpcConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.VpcConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.VpcConfigResponse =
      zio.aws.lambda.model.VpcConfigResponse(
        subnetIds.map(value => value),
        securityGroupIds.map(value => value),
        vpcId.map(value => value)
      )
    def subnetIds: Option[List[SubnetId]]
    def securityGroupIds: Option[List[SecurityGroupId]]
    def vpcId: Option[VpcId]
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.VpcConfigResponse
  ) extends zio.aws.lambda.model.VpcConfigResponse.ReadOnly {
    override val subnetIds: Option[List[SubnetId]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.SubnetId(item)
        }.toList
      )
    override val securityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.lambda.model.primitives.VpcId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.VpcConfigResponse
  ): zio.aws.lambda.model.VpcConfigResponse.ReadOnly = new Wrapper(impl)
}
