package zio.aws.lambda.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lambda.model.primitives.{
  AllowCredentials,
  Method,
  MaxAge,
  Origin,
  Header
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Cors(
    allowCredentials: Optional[AllowCredentials] = Optional.Absent,
    allowHeaders: Optional[Iterable[Header]] = Optional.Absent,
    allowMethods: Optional[Iterable[Method]] = Optional.Absent,
    allowOrigins: Optional[Iterable[Origin]] = Optional.Absent,
    exposeHeaders: Optional[Iterable[Header]] = Optional.Absent,
    maxAge: Optional[MaxAge] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.lambda.model.Cors = {
    import Cors.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.Cors
      .builder()
      .optionallyWith(
        allowCredentials.map(value =>
          AllowCredentials.unwrap(value): java.lang.Boolean
        )
      )(_.allowCredentials)
      .optionallyWith(
        allowHeaders.map(value =>
          value.map { item =>
            Header.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowHeaders)
      .optionallyWith(
        allowMethods.map(value =>
          value.map { item =>
            Method.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowMethods)
      .optionallyWith(
        allowOrigins.map(value =>
          value.map { item =>
            Origin.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowOrigins)
      .optionallyWith(
        exposeHeaders.map(value =>
          value.map { item =>
            Header.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.exposeHeaders)
      .optionallyWith(maxAge.map(value => MaxAge.unwrap(value): Integer))(
        _.maxAge
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.Cors.ReadOnly =
    zio.aws.lambda.model.Cors.wrap(buildAwsValue())
}
object Cors {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lambda.model.Cors] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.Cors = zio.aws.lambda.model.Cors(
      allowCredentials.map(value => value),
      allowHeaders.map(value => value),
      allowMethods.map(value => value),
      allowOrigins.map(value => value),
      exposeHeaders.map(value => value),
      maxAge.map(value => value)
    )
    def allowCredentials: Optional[AllowCredentials]
    def allowHeaders: Optional[List[Header]]
    def allowMethods: Optional[List[Method]]
    def allowOrigins: Optional[List[Origin]]
    def exposeHeaders: Optional[List[Header]]
    def maxAge: Optional[MaxAge]
    def getAllowCredentials: ZIO[Any, AwsError, AllowCredentials] =
      AwsError.unwrapOptionField("allowCredentials", allowCredentials)
    def getAllowHeaders: ZIO[Any, AwsError, List[Header]] =
      AwsError.unwrapOptionField("allowHeaders", allowHeaders)
    def getAllowMethods: ZIO[Any, AwsError, List[Method]] =
      AwsError.unwrapOptionField("allowMethods", allowMethods)
    def getAllowOrigins: ZIO[Any, AwsError, List[Origin]] =
      AwsError.unwrapOptionField("allowOrigins", allowOrigins)
    def getExposeHeaders: ZIO[Any, AwsError, List[Header]] =
      AwsError.unwrapOptionField("exposeHeaders", exposeHeaders)
    def getMaxAge: ZIO[Any, AwsError, MaxAge] =
      AwsError.unwrapOptionField("maxAge", maxAge)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.Cors
  ) extends zio.aws.lambda.model.Cors.ReadOnly {
    override val allowCredentials: Optional[AllowCredentials] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowCredentials())
        .map(value => zio.aws.lambda.model.primitives.AllowCredentials(value))
    override val allowHeaders: Optional[List[Header]] = zio.aws.core.internal
      .optionalFromNullable(impl.allowHeaders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.Header(item)
        }.toList
      )
    override val allowMethods: Optional[List[Method]] = zio.aws.core.internal
      .optionalFromNullable(impl.allowMethods())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.Method(item)
        }.toList
      )
    override val allowOrigins: Optional[List[Origin]] = zio.aws.core.internal
      .optionalFromNullable(impl.allowOrigins())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.Origin(item)
        }.toList
      )
    override val exposeHeaders: Optional[List[Header]] = zio.aws.core.internal
      .optionalFromNullable(impl.exposeHeaders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.Header(item)
        }.toList
      )
    override val maxAge: Optional[MaxAge] = zio.aws.core.internal
      .optionalFromNullable(impl.maxAge())
      .map(value => zio.aws.lambda.model.primitives.MaxAge(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.Cors
  ): zio.aws.lambda.model.Cors.ReadOnly = new Wrapper(impl)
}
