package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.ResourceArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeadLetterConfig(
    targetArn: Optional[ResourceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.DeadLetterConfig = {
    import DeadLetterConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.DeadLetterConfig
      .builder()
      .optionallyWith(
        targetArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.targetArn)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.DeadLetterConfig.ReadOnly =
    zio.aws.lambda.model.DeadLetterConfig.wrap(buildAwsValue())
}
object DeadLetterConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.DeadLetterConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.DeadLetterConfig =
      zio.aws.lambda.model.DeadLetterConfig(targetArn.map(value => value))
    def targetArn: Optional[ResourceArn]
    def getTargetArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("targetArn", targetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.DeadLetterConfig
  ) extends zio.aws.lambda.model.DeadLetterConfig.ReadOnly {
    override val targetArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.targetArn())
      .map(value => zio.aws.lambda.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.DeadLetterConfig
  ): zio.aws.lambda.model.DeadLetterConfig.ReadOnly = new Wrapper(impl)
}
