package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{Qualifier, FunctionName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteFunctionRequest(
    functionName: FunctionName,
    qualifier: Optional[Qualifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.DeleteFunctionRequest = {
    import DeleteFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.DeleteFunctionRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .optionallyWith(
        qualifier.map(value => Qualifier.unwrap(value): java.lang.String)
      )(_.qualifier)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.DeleteFunctionRequest.ReadOnly =
    zio.aws.lambda.model.DeleteFunctionRequest.wrap(buildAwsValue())
}
object DeleteFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.DeleteFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.DeleteFunctionRequest =
      zio.aws.lambda.model
        .DeleteFunctionRequest(functionName, qualifier.map(value => value))
    def functionName: FunctionName
    def qualifier: Optional[Qualifier]
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getQualifier: ZIO[Any, AwsError, Qualifier] =
      AwsError.unwrapOptionField("qualifier", qualifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.DeleteFunctionRequest
  ) extends zio.aws.lambda.model.DeleteFunctionRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val qualifier: Optional[Qualifier] = zio.aws.core.internal
      .optionalFromNullable(impl.qualifier())
      .map(value => zio.aws.lambda.model.primitives.Qualifier(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.DeleteFunctionRequest
  ): zio.aws.lambda.model.DeleteFunctionRequest.ReadOnly = new Wrapper(impl)
}
