package zio.aws.lambda.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lambda.model.primitives.{
  MaximumRetryAttemptsEventSourceMapping,
  BatchSize,
  BisectBatchOnFunctionError,
  Date,
  MaximumBatchingWindowInSeconds,
  Queue,
  Arn,
  ParallelizationFactor,
  FunctionArn,
  Topic,
  TumblingWindowInSeconds,
  MaximumRecordAgeInSeconds
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class EventSourceMappingConfiguration(
    uuid: Optional[String] = Optional.Absent,
    startingPosition: Optional[zio.aws.lambda.model.EventSourcePosition] =
      Optional.Absent,
    startingPositionTimestamp: Optional[Date] = Optional.Absent,
    batchSize: Optional[BatchSize] = Optional.Absent,
    maximumBatchingWindowInSeconds: Optional[MaximumBatchingWindowInSeconds] =
      Optional.Absent,
    parallelizationFactor: Optional[ParallelizationFactor] = Optional.Absent,
    eventSourceArn: Optional[Arn] = Optional.Absent,
    filterCriteria: Optional[zio.aws.lambda.model.FilterCriteria] =
      Optional.Absent,
    functionArn: Optional[FunctionArn] = Optional.Absent,
    lastModified: Optional[Date] = Optional.Absent,
    lastProcessingResult: Optional[String] = Optional.Absent,
    state: Optional[String] = Optional.Absent,
    stateTransitionReason: Optional[String] = Optional.Absent,
    destinationConfig: Optional[zio.aws.lambda.model.DestinationConfig] =
      Optional.Absent,
    topics: Optional[Iterable[Topic]] = Optional.Absent,
    queues: Optional[Iterable[Queue]] = Optional.Absent,
    sourceAccessConfigurations: Optional[
      Iterable[zio.aws.lambda.model.SourceAccessConfiguration]
    ] = Optional.Absent,
    selfManagedEventSource: Optional[
      zio.aws.lambda.model.SelfManagedEventSource
    ] = Optional.Absent,
    maximumRecordAgeInSeconds: Optional[MaximumRecordAgeInSeconds] =
      Optional.Absent,
    bisectBatchOnFunctionError: Optional[BisectBatchOnFunctionError] =
      Optional.Absent,
    maximumRetryAttempts: Optional[MaximumRetryAttemptsEventSourceMapping] =
      Optional.Absent,
    tumblingWindowInSeconds: Optional[TumblingWindowInSeconds] =
      Optional.Absent,
    functionResponseTypes: Optional[
      Iterable[zio.aws.lambda.model.FunctionResponseType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.EventSourceMappingConfiguration = {
    import EventSourceMappingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.EventSourceMappingConfiguration
      .builder()
      .optionallyWith(uuid.map(value => value: java.lang.String))(_.uuid)
      .optionallyWith(startingPosition.map(value => value.unwrap))(
        _.startingPosition
      )
      .optionallyWith(
        startingPositionTimestamp.map(value => Date.unwrap(value): Instant)
      )(_.startingPositionTimestamp)
      .optionallyWith(batchSize.map(value => BatchSize.unwrap(value): Integer))(
        _.batchSize
      )
      .optionallyWith(
        maximumBatchingWindowInSeconds.map(value =>
          MaximumBatchingWindowInSeconds.unwrap(value): Integer
        )
      )(_.maximumBatchingWindowInSeconds)
      .optionallyWith(
        parallelizationFactor.map(value =>
          ParallelizationFactor.unwrap(value): Integer
        )
      )(_.parallelizationFactor)
      .optionallyWith(
        eventSourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.eventSourceArn)
      .optionallyWith(filterCriteria.map(value => value.buildAwsValue()))(
        _.filterCriteria
      )
      .optionallyWith(
        functionArn.map(value => FunctionArn.unwrap(value): java.lang.String)
      )(_.functionArn)
      .optionallyWith(lastModified.map(value => Date.unwrap(value): Instant))(
        _.lastModified
      )
      .optionallyWith(
        lastProcessingResult.map(value => value: java.lang.String)
      )(_.lastProcessingResult)
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(
        stateTransitionReason.map(value => value: java.lang.String)
      )(_.stateTransitionReason)
      .optionallyWith(destinationConfig.map(value => value.buildAwsValue()))(
        _.destinationConfig
      )
      .optionallyWith(
        topics.map(value =>
          value.map { item =>
            Topic.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.topics)
      .optionallyWith(
        queues.map(value =>
          value.map { item =>
            Queue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.queues)
      .optionallyWith(
        sourceAccessConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceAccessConfigurations)
      .optionallyWith(
        selfManagedEventSource.map(value => value.buildAwsValue())
      )(_.selfManagedEventSource)
      .optionallyWith(
        maximumRecordAgeInSeconds.map(value =>
          MaximumRecordAgeInSeconds.unwrap(value): Integer
        )
      )(_.maximumRecordAgeInSeconds)
      .optionallyWith(
        bisectBatchOnFunctionError.map(value =>
          BisectBatchOnFunctionError.unwrap(value): java.lang.Boolean
        )
      )(_.bisectBatchOnFunctionError)
      .optionallyWith(
        maximumRetryAttempts.map(value =>
          MaximumRetryAttemptsEventSourceMapping.unwrap(value): Integer
        )
      )(_.maximumRetryAttempts)
      .optionallyWith(
        tumblingWindowInSeconds.map(value =>
          TumblingWindowInSeconds.unwrap(value): Integer
        )
      )(_.tumblingWindowInSeconds)
      .optionallyWith(
        functionResponseTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.functionResponseTypesWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.EventSourceMappingConfiguration.ReadOnly =
    zio.aws.lambda.model.EventSourceMappingConfiguration.wrap(buildAwsValue())
}
object EventSourceMappingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.EventSourceMappingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.EventSourceMappingConfiguration =
      zio.aws.lambda.model.EventSourceMappingConfiguration(
        uuid.map(value => value),
        startingPosition.map(value => value),
        startingPositionTimestamp.map(value => value),
        batchSize.map(value => value),
        maximumBatchingWindowInSeconds.map(value => value),
        parallelizationFactor.map(value => value),
        eventSourceArn.map(value => value),
        filterCriteria.map(value => value.asEditable),
        functionArn.map(value => value),
        lastModified.map(value => value),
        lastProcessingResult.map(value => value),
        state.map(value => value),
        stateTransitionReason.map(value => value),
        destinationConfig.map(value => value.asEditable),
        topics.map(value => value),
        queues.map(value => value),
        sourceAccessConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        selfManagedEventSource.map(value => value.asEditable),
        maximumRecordAgeInSeconds.map(value => value),
        bisectBatchOnFunctionError.map(value => value),
        maximumRetryAttempts.map(value => value),
        tumblingWindowInSeconds.map(value => value),
        functionResponseTypes.map(value => value)
      )
    def uuid: Optional[String]
    def startingPosition: Optional[zio.aws.lambda.model.EventSourcePosition]
    def startingPositionTimestamp: Optional[Date]
    def batchSize: Optional[BatchSize]
    def maximumBatchingWindowInSeconds: Optional[MaximumBatchingWindowInSeconds]
    def parallelizationFactor: Optional[ParallelizationFactor]
    def eventSourceArn: Optional[Arn]
    def filterCriteria: Optional[zio.aws.lambda.model.FilterCriteria.ReadOnly]
    def functionArn: Optional[FunctionArn]
    def lastModified: Optional[Date]
    def lastProcessingResult: Optional[String]
    def state: Optional[String]
    def stateTransitionReason: Optional[String]
    def destinationConfig
        : Optional[zio.aws.lambda.model.DestinationConfig.ReadOnly]
    def topics: Optional[List[Topic]]
    def queues: Optional[List[Queue]]
    def sourceAccessConfigurations: Optional[
      List[zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly]
    ]
    def selfManagedEventSource
        : Optional[zio.aws.lambda.model.SelfManagedEventSource.ReadOnly]
    def maximumRecordAgeInSeconds: Optional[MaximumRecordAgeInSeconds]
    def bisectBatchOnFunctionError: Optional[BisectBatchOnFunctionError]
    def maximumRetryAttempts: Optional[MaximumRetryAttemptsEventSourceMapping]
    def tumblingWindowInSeconds: Optional[TumblingWindowInSeconds]
    def functionResponseTypes
        : Optional[List[zio.aws.lambda.model.FunctionResponseType]]
    def getUuid: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("uuid", uuid)
    def getStartingPosition
        : ZIO[Any, AwsError, zio.aws.lambda.model.EventSourcePosition] =
      AwsError.unwrapOptionField("startingPosition", startingPosition)
    def getStartingPositionTimestamp: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("startingPositionTimestamp", startingPositionTimestamp)
    def getBatchSize: ZIO[Any, AwsError, BatchSize] =
      AwsError.unwrapOptionField("batchSize", batchSize)
    def getMaximumBatchingWindowInSeconds
        : ZIO[Any, AwsError, MaximumBatchingWindowInSeconds] =
      AwsError.unwrapOptionField(
        "maximumBatchingWindowInSeconds",
        maximumBatchingWindowInSeconds
      )
    def getParallelizationFactor: ZIO[Any, AwsError, ParallelizationFactor] =
      AwsError.unwrapOptionField("parallelizationFactor", parallelizationFactor)
    def getEventSourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("eventSourceArn", eventSourceArn)
    def getFilterCriteria
        : ZIO[Any, AwsError, zio.aws.lambda.model.FilterCriteria.ReadOnly] =
      AwsError.unwrapOptionField("filterCriteria", filterCriteria)
    def getFunctionArn: ZIO[Any, AwsError, FunctionArn] =
      AwsError.unwrapOptionField("functionArn", functionArn)
    def getLastModified: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getLastProcessingResult: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastProcessingResult", lastProcessingResult)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getStateTransitionReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stateTransitionReason", stateTransitionReason)
    def getDestinationConfig
        : ZIO[Any, AwsError, zio.aws.lambda.model.DestinationConfig.ReadOnly] =
      AwsError.unwrapOptionField("destinationConfig", destinationConfig)
    def getTopics: ZIO[Any, AwsError, List[Topic]] =
      AwsError.unwrapOptionField("topics", topics)
    def getQueues: ZIO[Any, AwsError, List[Queue]] =
      AwsError.unwrapOptionField("queues", queues)
    def getSourceAccessConfigurations: ZIO[Any, AwsError, List[
      zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "sourceAccessConfigurations",
      sourceAccessConfigurations
    )
    def getSelfManagedEventSource: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.SelfManagedEventSource.ReadOnly
    ] = AwsError.unwrapOptionField(
      "selfManagedEventSource",
      selfManagedEventSource
    )
    def getMaximumRecordAgeInSeconds
        : ZIO[Any, AwsError, MaximumRecordAgeInSeconds] = AwsError
      .unwrapOptionField("maximumRecordAgeInSeconds", maximumRecordAgeInSeconds)
    def getBisectBatchOnFunctionError
        : ZIO[Any, AwsError, BisectBatchOnFunctionError] =
      AwsError.unwrapOptionField(
        "bisectBatchOnFunctionError",
        bisectBatchOnFunctionError
      )
    def getMaximumRetryAttempts
        : ZIO[Any, AwsError, MaximumRetryAttemptsEventSourceMapping] =
      AwsError.unwrapOptionField("maximumRetryAttempts", maximumRetryAttempts)
    def getTumblingWindowInSeconds
        : ZIO[Any, AwsError, TumblingWindowInSeconds] = AwsError
      .unwrapOptionField("tumblingWindowInSeconds", tumblingWindowInSeconds)
    def getFunctionResponseTypes
        : ZIO[Any, AwsError, List[zio.aws.lambda.model.FunctionResponseType]] =
      AwsError.unwrapOptionField("functionResponseTypes", functionResponseTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.EventSourceMappingConfiguration
  ) extends zio.aws.lambda.model.EventSourceMappingConfiguration.ReadOnly {
    override val uuid: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.uuid())
      .map(value => value: String)
    override val startingPosition
        : Optional[zio.aws.lambda.model.EventSourcePosition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startingPosition())
        .map(value => zio.aws.lambda.model.EventSourcePosition.wrap(value))
    override val startingPositionTimestamp: Optional[Date] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startingPositionTimestamp())
        .map(value => zio.aws.lambda.model.primitives.Date(value))
    override val batchSize: Optional[BatchSize] = zio.aws.core.internal
      .optionalFromNullable(impl.batchSize())
      .map(value => zio.aws.lambda.model.primitives.BatchSize(value))
    override val maximumBatchingWindowInSeconds
        : Optional[MaximumBatchingWindowInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumBatchingWindowInSeconds())
      .map(value =>
        zio.aws.lambda.model.primitives.MaximumBatchingWindowInSeconds(value)
      )
    override val parallelizationFactor: Optional[ParallelizationFactor] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parallelizationFactor())
        .map(value =>
          zio.aws.lambda.model.primitives.ParallelizationFactor(value)
        )
    override val eventSourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.eventSourceArn())
      .map(value => zio.aws.lambda.model.primitives.Arn(value))
    override val filterCriteria
        : Optional[zio.aws.lambda.model.FilterCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCriteria())
        .map(value => zio.aws.lambda.model.FilterCriteria.wrap(value))
    override val functionArn: Optional[FunctionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.functionArn())
      .map(value => zio.aws.lambda.model.primitives.FunctionArn(value))
    override val lastModified: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModified())
      .map(value => zio.aws.lambda.model.primitives.Date(value))
    override val lastProcessingResult: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastProcessingResult())
      .map(value => value: String)
    override val state: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => value: String)
    override val stateTransitionReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stateTransitionReason())
      .map(value => value: String)
    override val destinationConfig
        : Optional[zio.aws.lambda.model.DestinationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationConfig())
        .map(value => zio.aws.lambda.model.DestinationConfig.wrap(value))
    override val topics: Optional[List[Topic]] = zio.aws.core.internal
      .optionalFromNullable(impl.topics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.Topic(item)
        }.toList
      )
    override val queues: Optional[List[Queue]] = zio.aws.core.internal
      .optionalFromNullable(impl.queues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.Queue(item)
        }.toList
      )
    override val sourceAccessConfigurations: Optional[
      List[zio.aws.lambda.model.SourceAccessConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceAccessConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.SourceAccessConfiguration.wrap(item)
        }.toList
      )
    override val selfManagedEventSource
        : Optional[zio.aws.lambda.model.SelfManagedEventSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selfManagedEventSource())
        .map(value => zio.aws.lambda.model.SelfManagedEventSource.wrap(value))
    override val maximumRecordAgeInSeconds
        : Optional[MaximumRecordAgeInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumRecordAgeInSeconds())
      .map(value =>
        zio.aws.lambda.model.primitives.MaximumRecordAgeInSeconds(value)
      )
    override val bisectBatchOnFunctionError
        : Optional[BisectBatchOnFunctionError] = zio.aws.core.internal
      .optionalFromNullable(impl.bisectBatchOnFunctionError())
      .map(value =>
        zio.aws.lambda.model.primitives.BisectBatchOnFunctionError(value)
      )
    override val maximumRetryAttempts
        : Optional[MaximumRetryAttemptsEventSourceMapping] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumRetryAttempts())
        .map(value =>
          zio.aws.lambda.model.primitives
            .MaximumRetryAttemptsEventSourceMapping(value)
        )
    override val tumblingWindowInSeconds: Optional[TumblingWindowInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tumblingWindowInSeconds())
        .map(value =>
          zio.aws.lambda.model.primitives.TumblingWindowInSeconds(value)
        )
    override val functionResponseTypes
        : Optional[List[zio.aws.lambda.model.FunctionResponseType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionResponseTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lambda.model.FunctionResponseType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.EventSourceMappingConfiguration
  ): zio.aws.lambda.model.EventSourceMappingConfiguration.ReadOnly =
    new Wrapper(impl)
}
