package zio.aws.lambda.model
import scala.jdk.CollectionConverters._
sealed trait EventSourcePosition {
  def unwrap: software.amazon.awssdk.services.lambda.model.EventSourcePosition
}
object EventSourcePosition {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.EventSourcePosition
  ): zio.aws.lambda.model.EventSourcePosition = value match {
    case software.amazon.awssdk.services.lambda.model.EventSourcePosition.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.EventSourcePosition.TRIM_HORIZON =>
      val r = TRIM_HORIZON
      r
    case software.amazon.awssdk.services.lambda.model.EventSourcePosition.LATEST =>
      val r = LATEST
      r
    case software.amazon.awssdk.services.lambda.model.EventSourcePosition.AT_TIMESTAMP =>
      val r = AT_TIMESTAMP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lambda.model.EventSourcePosition {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.EventSourcePosition =
      software.amazon.awssdk.services.lambda.model.EventSourcePosition.UNKNOWN_TO_SDK_VERSION
  }
  case object TRIM_HORIZON extends zio.aws.lambda.model.EventSourcePosition {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.EventSourcePosition =
      software.amazon.awssdk.services.lambda.model.EventSourcePosition.TRIM_HORIZON
  }
  case object LATEST extends zio.aws.lambda.model.EventSourcePosition {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.EventSourcePosition =
      software.amazon.awssdk.services.lambda.model.EventSourcePosition.LATEST
  }
  case object AT_TIMESTAMP extends zio.aws.lambda.model.EventSourcePosition {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.EventSourcePosition =
      software.amazon.awssdk.services.lambda.model.EventSourcePosition.AT_TIMESTAMP
  }
}
