package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{FunctionName, CodeSigningConfigArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetFunctionCodeSigningConfigResponse(
    codeSigningConfigArn: CodeSigningConfigArn,
    functionName: FunctionName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetFunctionCodeSigningConfigResponse = {
    import GetFunctionCodeSigningConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetFunctionCodeSigningConfigResponse
      .builder()
      .codeSigningConfigArn(
        CodeSigningConfigArn.unwrap(codeSigningConfigArn): java.lang.String
      )
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.GetFunctionCodeSigningConfigResponse.ReadOnly =
    zio.aws.lambda.model.GetFunctionCodeSigningConfigResponse
      .wrap(buildAwsValue())
}
object GetFunctionCodeSigningConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetFunctionCodeSigningConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetFunctionCodeSigningConfigResponse =
      zio.aws.lambda.model.GetFunctionCodeSigningConfigResponse(
        codeSigningConfigArn,
        functionName
      )
    def codeSigningConfigArn: CodeSigningConfigArn
    def functionName: FunctionName
    def getCodeSigningConfigArn: ZIO[Any, Nothing, CodeSigningConfigArn] =
      ZIO.succeed(codeSigningConfigArn)
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionCodeSigningConfigResponse
  ) extends zio.aws.lambda.model.GetFunctionCodeSigningConfigResponse.ReadOnly {
    override val codeSigningConfigArn: CodeSigningConfigArn =
      zio.aws.lambda.model.primitives
        .CodeSigningConfigArn(impl.codeSigningConfigArn())
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionCodeSigningConfigResponse
  ): zio.aws.lambda.model.GetFunctionCodeSigningConfigResponse.ReadOnly =
    new Wrapper(impl)
}
