package zio.aws.lambda.model
import scala.jdk.CollectionConverters._
sealed trait PackageType {
  def unwrap: software.amazon.awssdk.services.lambda.model.PackageType
}
object PackageType {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.PackageType
  ): zio.aws.lambda.model.PackageType = value match {
    case software.amazon.awssdk.services.lambda.model.PackageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.PackageType.ZIP =>
      val r = Zip
      r
    case software.amazon.awssdk.services.lambda.model.PackageType.IMAGE =>
      val r = Image
      r
  }
  case object unknownToSdkVersion extends zio.aws.lambda.model.PackageType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.PackageType =
      software.amazon.awssdk.services.lambda.model.PackageType.UNKNOWN_TO_SDK_VERSION
  }
  case object Zip extends zio.aws.lambda.model.PackageType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.PackageType =
      software.amazon.awssdk.services.lambda.model.PackageType.ZIP
  }
  case object Image extends zio.aws.lambda.model.PackageType {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.PackageType =
      software.amazon.awssdk.services.lambda.model.PackageType.IMAGE
  }
}
