package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{TagKey, FunctionArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resource: FunctionArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.UntagResourceRequest
      .builder()
      .resource(FunctionArn.unwrap(resource): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.UntagResourceRequest.ReadOnly =
    zio.aws.lambda.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.UntagResourceRequest =
      zio.aws.lambda.model.UntagResourceRequest(resource, tagKeys)
    def resource: FunctionArn
    def tagKeys: List[TagKey]
    def getResource: ZIO[Any, Nothing, FunctionArn] = ZIO.succeed(resource)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.UntagResourceRequest
  ) extends zio.aws.lambda.model.UntagResourceRequest.ReadOnly {
    override val resource: FunctionArn =
      zio.aws.lambda.model.primitives.FunctionArn(impl.resource())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.lambda.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.UntagResourceRequest
  ): zio.aws.lambda.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
