package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{Description, CodeSigningConfigArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateCodeSigningConfigRequest(
    codeSigningConfigArn: CodeSigningConfigArn,
    description: Optional[Description] = Optional.Absent,
    allowedPublishers: Optional[zio.aws.lambda.model.AllowedPublishers] =
      Optional.Absent,
    codeSigningPolicies: Optional[zio.aws.lambda.model.CodeSigningPolicies] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.UpdateCodeSigningConfigRequest = {
    import UpdateCodeSigningConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.UpdateCodeSigningConfigRequest
      .builder()
      .codeSigningConfigArn(
        CodeSigningConfigArn.unwrap(codeSigningConfigArn): java.lang.String
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(allowedPublishers.map(value => value.buildAwsValue()))(
        _.allowedPublishers
      )
      .optionallyWith(codeSigningPolicies.map(value => value.buildAwsValue()))(
        _.codeSigningPolicies
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.UpdateCodeSigningConfigRequest.ReadOnly =
    zio.aws.lambda.model.UpdateCodeSigningConfigRequest.wrap(buildAwsValue())
}
object UpdateCodeSigningConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.UpdateCodeSigningConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.UpdateCodeSigningConfigRequest =
      zio.aws.lambda.model.UpdateCodeSigningConfigRequest(
        codeSigningConfigArn,
        description.map(value => value),
        allowedPublishers.map(value => value.asEditable),
        codeSigningPolicies.map(value => value.asEditable)
      )
    def codeSigningConfigArn: CodeSigningConfigArn
    def description: Optional[Description]
    def allowedPublishers
        : Optional[zio.aws.lambda.model.AllowedPublishers.ReadOnly]
    def codeSigningPolicies
        : Optional[zio.aws.lambda.model.CodeSigningPolicies.ReadOnly]
    def getCodeSigningConfigArn: ZIO[Any, Nothing, CodeSigningConfigArn] =
      ZIO.succeed(codeSigningConfigArn)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getAllowedPublishers
        : ZIO[Any, AwsError, zio.aws.lambda.model.AllowedPublishers.ReadOnly] =
      AwsError.unwrapOptionField("allowedPublishers", allowedPublishers)
    def getCodeSigningPolicies: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.CodeSigningPolicies.ReadOnly
    ] = AwsError.unwrapOptionField("codeSigningPolicies", codeSigningPolicies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.UpdateCodeSigningConfigRequest
  ) extends zio.aws.lambda.model.UpdateCodeSigningConfigRequest.ReadOnly {
    override val codeSigningConfigArn: CodeSigningConfigArn =
      zio.aws.lambda.model.primitives
        .CodeSigningConfigArn(impl.codeSigningConfigArn())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lambda.model.primitives.Description(value))
    override val allowedPublishers
        : Optional[zio.aws.lambda.model.AllowedPublishers.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowedPublishers())
        .map(value => zio.aws.lambda.model.AllowedPublishers.wrap(value))
    override val codeSigningPolicies
        : Optional[zio.aws.lambda.model.CodeSigningPolicies.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeSigningPolicies())
        .map(value => zio.aws.lambda.model.CodeSigningPolicies.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.UpdateCodeSigningConfigRequest
  ): zio.aws.lambda.model.UpdateCodeSigningConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
