package zio.aws.lambda.model
import java.lang.Integer
import zio.aws.lambda.model.primitives.EphemeralStorageSize
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EphemeralStorage(size: EphemeralStorageSize) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.EphemeralStorage = {
    import EphemeralStorage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.EphemeralStorage
      .builder()
      .size(EphemeralStorageSize.unwrap(size): Integer)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.EphemeralStorage.ReadOnly =
    zio.aws.lambda.model.EphemeralStorage.wrap(buildAwsValue())
}
object EphemeralStorage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.EphemeralStorage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.EphemeralStorage =
      zio.aws.lambda.model.EphemeralStorage(size)
    def size: EphemeralStorageSize
    def getSize: ZIO[Any, Nothing, EphemeralStorageSize] = ZIO.succeed(size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.EphemeralStorage
  ) extends zio.aws.lambda.model.EphemeralStorage.ReadOnly {
    override val size: EphemeralStorageSize =
      zio.aws.lambda.model.primitives.EphemeralStorageSize(impl.size())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.EphemeralStorage
  ): zio.aws.lambda.model.EphemeralStorage.ReadOnly = new Wrapper(impl)
}
