package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{LocalMountPath, FileSystemArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class FileSystemConfig(
    arn: FileSystemArn,
    localMountPath: LocalMountPath
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.FileSystemConfig = {
    import FileSystemConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.FileSystemConfig
      .builder()
      .arn(FileSystemArn.unwrap(arn): java.lang.String)
      .localMountPath(LocalMountPath.unwrap(localMountPath): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.FileSystemConfig.ReadOnly =
    zio.aws.lambda.model.FileSystemConfig.wrap(buildAwsValue())
}
object FileSystemConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.FileSystemConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.FileSystemConfig =
      zio.aws.lambda.model.FileSystemConfig(arn, localMountPath)
    def arn: FileSystemArn
    def localMountPath: LocalMountPath
    def getArn: ZIO[Any, Nothing, FileSystemArn] = ZIO.succeed(arn)
    def getLocalMountPath: ZIO[Any, Nothing, LocalMountPath] =
      ZIO.succeed(localMountPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.FileSystemConfig
  ) extends zio.aws.lambda.model.FileSystemConfig.ReadOnly {
    override val arn: FileSystemArn =
      zio.aws.lambda.model.primitives.FileSystemArn(impl.arn())
    override val localMountPath: LocalMountPath =
      zio.aws.lambda.model.primitives.LocalMountPath(impl.localMountPath())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.FileSystemConfig
  ): zio.aws.lambda.model.FileSystemConfig.ReadOnly = new Wrapper(impl)
}
