package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{Qualifier, NamespacedFunctionName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPolicyRequest(
    functionName: NamespacedFunctionName,
    qualifier: Optional[Qualifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetPolicyRequest = {
    import GetPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetPolicyRequest
      .builder()
      .functionName(
        NamespacedFunctionName.unwrap(functionName): java.lang.String
      )
      .optionallyWith(
        qualifier.map(value => Qualifier.unwrap(value): java.lang.String)
      )(_.qualifier)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.GetPolicyRequest.ReadOnly =
    zio.aws.lambda.model.GetPolicyRequest.wrap(buildAwsValue())
}
object GetPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetPolicyRequest = zio.aws.lambda.model
      .GetPolicyRequest(functionName, qualifier.map(value => value))
    def functionName: NamespacedFunctionName
    def qualifier: Optional[Qualifier]
    def getFunctionName: ZIO[Any, Nothing, NamespacedFunctionName] =
      ZIO.succeed(functionName)
    def getQualifier: ZIO[Any, AwsError, Qualifier] =
      AwsError.unwrapOptionField("qualifier", qualifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetPolicyRequest
  ) extends zio.aws.lambda.model.GetPolicyRequest.ReadOnly {
    override val functionName: NamespacedFunctionName =
      zio.aws.lambda.model.primitives
        .NamespacedFunctionName(impl.functionName())
    override val qualifier: Optional[Qualifier] = zio.aws.core.internal
      .optionalFromNullable(impl.qualifier())
      .map(value => zio.aws.lambda.model.primitives.Qualifier(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetPolicyRequest
  ): zio.aws.lambda.model.GetPolicyRequest.ReadOnly = new Wrapper(impl)
}
