package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{Arn, LayerVersionArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Layer(
    arn: Optional[LayerVersionArn] = Optional.Absent,
    codeSize: Optional[Long] = Optional.Absent,
    signingProfileVersionArn: Optional[Arn] = Optional.Absent,
    signingJobArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.lambda.model.Layer = {
    import Layer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.Layer
      .builder()
      .optionallyWith(
        arn.map(value => LayerVersionArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(codeSize.map(value => value: java.lang.Long))(_.codeSize)
      .optionallyWith(
        signingProfileVersionArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.signingProfileVersionArn)
      .optionallyWith(
        signingJobArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.signingJobArn)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.Layer.ReadOnly =
    zio.aws.lambda.model.Layer.wrap(buildAwsValue())
}
object Layer {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lambda.model.Layer] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.Layer = zio.aws.lambda.model.Layer(
      arn.map(value => value),
      codeSize.map(value => value),
      signingProfileVersionArn.map(value => value),
      signingJobArn.map(value => value)
    )
    def arn: Optional[LayerVersionArn]
    def codeSize: Optional[Long]
    def signingProfileVersionArn: Optional[Arn]
    def signingJobArn: Optional[Arn]
    def getArn: ZIO[Any, AwsError, LayerVersionArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCodeSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("codeSize", codeSize)
    def getSigningProfileVersionArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("signingProfileVersionArn", signingProfileVersionArn)
    def getSigningJobArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("signingJobArn", signingJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.Layer
  ) extends zio.aws.lambda.model.Layer.ReadOnly {
    override val arn: Optional[LayerVersionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.lambda.model.primitives.LayerVersionArn(value))
    override val codeSize: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.codeSize())
      .map(value => value: Long)
    override val signingProfileVersionArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.signingProfileVersionArn())
      .map(value => zio.aws.lambda.model.primitives.Arn(value))
    override val signingJobArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.signingJobArn())
      .map(value => zio.aws.lambda.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.Layer
  ): zio.aws.lambda.model.Layer.ReadOnly = new Wrapper(impl)
}
