package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{Blob, S3ObjectVersion, S3Key, S3Bucket}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LayerVersionContentInput(
    s3Bucket: Optional[S3Bucket] = Optional.Absent,
    s3Key: Optional[S3Key] = Optional.Absent,
    s3ObjectVersion: Optional[S3ObjectVersion] = Optional.Absent,
    zipFile: Optional[Blob] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.LayerVersionContentInput = {
    import LayerVersionContentInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.LayerVersionContentInput
      .builder()
      .optionallyWith(
        s3Bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.s3Bucket)
      .optionallyWith(
        s3Key.map(value => S3Key.unwrap(value): java.lang.String)
      )(_.s3Key)
      .optionallyWith(
        s3ObjectVersion.map(value =>
          S3ObjectVersion.unwrap(value): java.lang.String
        )
      )(_.s3ObjectVersion)
      .optionallyWith(
        zipFile.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.zipFile)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.LayerVersionContentInput.ReadOnly =
    zio.aws.lambda.model.LayerVersionContentInput.wrap(buildAwsValue())
}
object LayerVersionContentInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.LayerVersionContentInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.LayerVersionContentInput =
      zio.aws.lambda.model.LayerVersionContentInput(
        s3Bucket.map(value => value),
        s3Key.map(value => value),
        s3ObjectVersion.map(value => value),
        zipFile.map(value => value)
      )
    def s3Bucket: Optional[S3Bucket]
    def s3Key: Optional[S3Key]
    def s3ObjectVersion: Optional[S3ObjectVersion]
    def zipFile: Optional[Blob]
    def getS3Bucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3Key: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("s3Key", s3Key)
    def getS3ObjectVersion: ZIO[Any, AwsError, S3ObjectVersion] =
      AwsError.unwrapOptionField("s3ObjectVersion", s3ObjectVersion)
    def getZipFile: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("zipFile", zipFile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.LayerVersionContentInput
  ) extends zio.aws.lambda.model.LayerVersionContentInput.ReadOnly {
    override val s3Bucket: Optional[S3Bucket] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Bucket())
      .map(value => zio.aws.lambda.model.primitives.S3Bucket(value))
    override val s3Key: Optional[S3Key] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Key())
      .map(value => zio.aws.lambda.model.primitives.S3Key(value))
    override val s3ObjectVersion: Optional[S3ObjectVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3ObjectVersion())
        .map(value => zio.aws.lambda.model.primitives.S3ObjectVersion(value))
    override val zipFile: Optional[Blob] = zio.aws.core.internal
      .optionalFromNullable(impl.zipFile())
      .map(value =>
        zio.aws.lambda.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.LayerVersionContentInput
  ): zio.aws.lambda.model.LayerVersionContentInput.ReadOnly = new Wrapper(impl)
}
