package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFunctionEventInvokeConfigsResponse(
    functionEventInvokeConfigs: Optional[
      Iterable[zio.aws.lambda.model.FunctionEventInvokeConfig]
    ] = Optional.Absent,
    nextMarker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsResponse = {
    import ListFunctionEventInvokeConfigsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsResponse
      .builder()
      .optionallyWith(
        functionEventInvokeConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.functionEventInvokeConfigs)
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.ListFunctionEventInvokeConfigsResponse.ReadOnly =
    zio.aws.lambda.model.ListFunctionEventInvokeConfigsResponse
      .wrap(buildAwsValue())
}
object ListFunctionEventInvokeConfigsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lambda.model.ListFunctionEventInvokeConfigsResponse =
      zio.aws.lambda.model.ListFunctionEventInvokeConfigsResponse(
        functionEventInvokeConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def functionEventInvokeConfigs: Optional[
      List[zio.aws.lambda.model.FunctionEventInvokeConfig.ReadOnly]
    ]
    def nextMarker: Optional[String]
    def getFunctionEventInvokeConfigs: ZIO[Any, AwsError, List[
      zio.aws.lambda.model.FunctionEventInvokeConfig.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "functionEventInvokeConfigs",
      functionEventInvokeConfigs
    )
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsResponse
  ) extends zio.aws.lambda.model.ListFunctionEventInvokeConfigsResponse.ReadOnly {
    override val functionEventInvokeConfigs: Optional[
      List[zio.aws.lambda.model.FunctionEventInvokeConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.functionEventInvokeConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.FunctionEventInvokeConfig.wrap(item)
        }.toList
      )
    override val nextMarker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsResponse
  ): zio.aws.lambda.model.ListFunctionEventInvokeConfigsResponse.ReadOnly =
    new Wrapper(impl)
}
