package zio.aws.lambda.model
import scala.jdk.CollectionConverters._
sealed trait ProvisionedConcurrencyStatusEnum {
  def unwrap: software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyStatusEnum
}
object ProvisionedConcurrencyStatusEnum {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyStatusEnum
  ): zio.aws.lambda.model.ProvisionedConcurrencyStatusEnum = value match {
    case software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyStatusEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyStatusEnum.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyStatusEnum.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyStatusEnum.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lambda.model.ProvisionedConcurrencyStatusEnum {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyStatusEnum =
      software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyStatusEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS
      extends zio.aws.lambda.model.ProvisionedConcurrencyStatusEnum {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyStatusEnum =
      software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyStatusEnum.IN_PROGRESS
  }
  case object READY
      extends zio.aws.lambda.model.ProvisionedConcurrencyStatusEnum {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyStatusEnum =
      software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyStatusEnum.READY
  }
  case object FAILED
      extends zio.aws.lambda.model.ProvisionedConcurrencyStatusEnum {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyStatusEnum =
      software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyStatusEnum.FAILED
  }
}
