package zio.aws.lambda.model
import java.lang.Integer
import zio.aws.lambda.model.primitives.{
  PositiveInteger,
  Qualifier,
  FunctionName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutProvisionedConcurrencyConfigRequest(
    functionName: FunctionName,
    qualifier: Qualifier,
    provisionedConcurrentExecutions: PositiveInteger
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.PutProvisionedConcurrencyConfigRequest = {
    import PutProvisionedConcurrencyConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.PutProvisionedConcurrencyConfigRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .qualifier(Qualifier.unwrap(qualifier): java.lang.String)
      .provisionedConcurrentExecutions(
        PositiveInteger.unwrap(provisionedConcurrentExecutions): Integer
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.PutProvisionedConcurrencyConfigRequest.ReadOnly =
    zio.aws.lambda.model.PutProvisionedConcurrencyConfigRequest
      .wrap(buildAwsValue())
}
object PutProvisionedConcurrencyConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.PutProvisionedConcurrencyConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lambda.model.PutProvisionedConcurrencyConfigRequest =
      zio.aws.lambda.model.PutProvisionedConcurrencyConfigRequest(
        functionName,
        qualifier,
        provisionedConcurrentExecutions
      )
    def functionName: FunctionName
    def qualifier: Qualifier
    def provisionedConcurrentExecutions: PositiveInteger
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
    def getQualifier: ZIO[Any, Nothing, Qualifier] = ZIO.succeed(qualifier)
    def getProvisionedConcurrentExecutions: ZIO[Any, Nothing, PositiveInteger] =
      ZIO.succeed(provisionedConcurrentExecutions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.PutProvisionedConcurrencyConfigRequest
  ) extends zio.aws.lambda.model.PutProvisionedConcurrencyConfigRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
    override val qualifier: Qualifier =
      zio.aws.lambda.model.primitives.Qualifier(impl.qualifier())
    override val provisionedConcurrentExecutions: PositiveInteger =
      zio.aws.lambda.model.primitives
        .PositiveInteger(impl.provisionedConcurrentExecutions())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.PutProvisionedConcurrencyConfigRequest
  ): zio.aws.lambda.model.PutProvisionedConcurrencyConfigRequest.ReadOnly =
    new Wrapper(impl)
}
