package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.{
  RoleArn,
  TagValue,
  SessionTTL,
  Name,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BotImportSpecification(
    botName: Name,
    roleArn: RoleArn,
    dataPrivacy: zio.aws.lexmodelsv2.model.DataPrivacy,
    idleSessionTTLInSeconds: Option[SessionTTL] = None,
    botTags: Option[Map[TagKey, TagValue]] = None,
    testBotAliasTags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotImportSpecification = {
    import BotImportSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotImportSpecification
      .builder()
      .botName(Name.unwrap(botName): java.lang.String)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .dataPrivacy(dataPrivacy.buildAwsValue())
      .optionallyWith(
        idleSessionTTLInSeconds.map(value => SessionTTL.unwrap(value): Integer)
      )(_.idleSessionTTLInSeconds)
      .optionallyWith(
        botTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.botTags)
      .optionallyWith(
        testBotAliasTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.testBotAliasTags)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BotImportSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.BotImportSpecification.wrap(buildAwsValue())
}
object BotImportSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotImportSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BotImportSpecification =
      zio.aws.lexmodelsv2.model.BotImportSpecification(
        botName,
        roleArn,
        dataPrivacy.asEditable,
        idleSessionTTLInSeconds.map(value => value),
        botTags.map(value => value),
        testBotAliasTags.map(value => value)
      )
    def botName: Name
    def roleArn: RoleArn
    def dataPrivacy: zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly
    def idleSessionTTLInSeconds: Option[SessionTTL]
    def botTags: Option[Map[TagKey, TagValue]]
    def testBotAliasTags: Option[Map[TagKey, TagValue]]
    def getBotName: ZIO[Any, Nothing, Name] = ZIO.succeed(botName)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getDataPrivacy
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly] =
      ZIO.succeed(dataPrivacy)
    def getIdleSessionTTLInSeconds: ZIO[Any, AwsError, SessionTTL] = AwsError
      .unwrapOptionField("idleSessionTTLInSeconds", idleSessionTTLInSeconds)
    def getBotTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("botTags", botTags)
    def getTestBotAliasTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("testBotAliasTags", testBotAliasTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotImportSpecification
  ) extends zio.aws.lexmodelsv2.model.BotImportSpecification.ReadOnly {
    override val botName: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.botName())
    override val roleArn: RoleArn =
      zio.aws.lexmodelsv2.model.primitives.RoleArn(impl.roleArn())
    override val dataPrivacy: zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly =
      zio.aws.lexmodelsv2.model.DataPrivacy.wrap(impl.dataPrivacy())
    override val idleSessionTTLInSeconds: Option[SessionTTL] = scala
      .Option(impl.idleSessionTTLInSeconds())
      .map(value => zio.aws.lexmodelsv2.model.primitives.SessionTTL(value))
    override val botTags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.botTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.primitives.TagKey(
              key
            ) -> zio.aws.lexmodelsv2.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val testBotAliasTags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.testBotAliasTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.primitives.TagKey(
              key
            ) -> zio.aws.lexmodelsv2.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotImportSpecification
  ): zio.aws.lexmodelsv2.model.BotImportSpecification.ReadOnly = new Wrapper(
    impl
  )
}
