package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  ConfidenceThreshold,
  LocaleId,
  DraftBotVersion,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BotLocaleImportSpecification(
    botId: Id,
    botVersion: DraftBotVersion,
    localeId: LocaleId,
    nluIntentConfidenceThreshold: Option[ConfidenceThreshold] = None,
    voiceSettings: Option[zio.aws.lexmodelsv2.model.VoiceSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleImportSpecification = {
    import BotLocaleImportSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleImportSpecification
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(DraftBotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .optionallyWith(
        nluIntentConfidenceThreshold.map(value =>
          ConfidenceThreshold.unwrap(value): java.lang.Double
        )
      )(_.nluIntentConfidenceThreshold)
      .optionallyWith(voiceSettings.map(value => value.buildAwsValue()))(
        _.voiceSettings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.BotLocaleImportSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.BotLocaleImportSpecification.wrap(buildAwsValue())
}
object BotLocaleImportSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleImportSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BotLocaleImportSpecification =
      zio.aws.lexmodelsv2.model.BotLocaleImportSpecification(
        botId,
        botVersion,
        localeId,
        nluIntentConfidenceThreshold.map(value => value),
        voiceSettings.map(value => value.asEditable)
      )
    def botId: Id
    def botVersion: DraftBotVersion
    def localeId: LocaleId
    def nluIntentConfidenceThreshold: Option[ConfidenceThreshold]
    def voiceSettings: Option[zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, DraftBotVersion] =
      ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getNluIntentConfidenceThreshold
        : ZIO[Any, AwsError, ConfidenceThreshold] = AwsError.unwrapOptionField(
      "nluIntentConfidenceThreshold",
      nluIntentConfidenceThreshold
    )
    def getVoiceSettings
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly] =
      AwsError.unwrapOptionField("voiceSettings", voiceSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleImportSpecification
  ) extends zio.aws.lexmodelsv2.model.BotLocaleImportSpecification.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: DraftBotVersion =
      zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
    override val nluIntentConfidenceThreshold: Option[ConfidenceThreshold] =
      scala
        .Option(impl.nluIntentConfidenceThreshold())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.ConfidenceThreshold(value)
        )
    override val voiceSettings
        : Option[zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly] = scala
      .Option(impl.voiceSettings())
      .map(value => zio.aws.lexmodelsv2.model.VoiceSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleImportSpecification
  ): zio.aws.lexmodelsv2.model.BotLocaleImportSpecification.ReadOnly =
    new Wrapper(impl)
}
