package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{Timestamp, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class BotRecommendationSummary(
    botRecommendationStatus: zio.aws.lexmodelsv2.model.BotRecommendationStatus,
    botRecommendationId: Id,
    creationDateTime: Option[Timestamp] = None,
    lastUpdatedDateTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationSummary = {
    import BotRecommendationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationSummary
      .builder()
      .botRecommendationStatus(botRecommendationStatus.unwrap)
      .botRecommendationId(Id.unwrap(botRecommendationId): java.lang.String)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BotRecommendationSummary.ReadOnly =
    zio.aws.lexmodelsv2.model.BotRecommendationSummary.wrap(buildAwsValue())
}
object BotRecommendationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BotRecommendationSummary =
      zio.aws.lexmodelsv2.model.BotRecommendationSummary(
        botRecommendationStatus,
        botRecommendationId,
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def botRecommendationStatus
        : zio.aws.lexmodelsv2.model.BotRecommendationStatus
    def botRecommendationId: Id
    def creationDateTime: Option[Timestamp]
    def lastUpdatedDateTime: Option[Timestamp]
    def getBotRecommendationStatus
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.BotRecommendationStatus] =
      ZIO.succeed(botRecommendationStatus)
    def getBotRecommendationId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(botRecommendationId)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationSummary
  ) extends zio.aws.lexmodelsv2.model.BotRecommendationSummary.ReadOnly {
    override val botRecommendationStatus
        : zio.aws.lexmodelsv2.model.BotRecommendationStatus =
      zio.aws.lexmodelsv2.model.BotRecommendationStatus
        .wrap(impl.botRecommendationStatus())
    override val botRecommendationId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botRecommendationId())
    override val creationDateTime: Option[Timestamp] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationSummary
  ): zio.aws.lexmodelsv2.model.BotRecommendationSummary.ReadOnly = new Wrapper(
    impl
  )
}
