package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  BotAliasId,
  Timestamp,
  TagValue,
  NumericalBotVersion,
  Description,
  Name,
  Id,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CreateBotAliasResponse(
    botAliasId: Option[BotAliasId] = None,
    botAliasName: Option[Name] = None,
    description: Option[Description] = None,
    botVersion: Option[NumericalBotVersion] = None,
    botAliasLocaleSettings: Option[
      Map[LocaleId, zio.aws.lexmodelsv2.model.BotAliasLocaleSettings]
    ] = None,
    conversationLogSettings: Option[
      zio.aws.lexmodelsv2.model.ConversationLogSettings
    ] = None,
    sentimentAnalysisSettings: Option[
      zio.aws.lexmodelsv2.model.SentimentAnalysisSettings
    ] = None,
    botAliasStatus: Option[zio.aws.lexmodelsv2.model.BotAliasStatus] = None,
    botId: Option[Id] = None,
    creationDateTime: Option[Timestamp] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasResponse = {
    import CreateBotAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasResponse
      .builder()
      .optionallyWith(
        botAliasId.map(value => BotAliasId.unwrap(value): java.lang.String)
      )(_.botAliasId)
      .optionallyWith(
        botAliasName.map(value => Name.unwrap(value): java.lang.String)
      )(_.botAliasName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        botVersion.map(value =>
          NumericalBotVersion.unwrap(value): java.lang.String
        )
      )(_.botVersion)
      .optionallyWith(
        botAliasLocaleSettings.map(value =>
          value
            .map({ case (key, value) =>
              (LocaleId.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.botAliasLocaleSettings)
      .optionallyWith(
        conversationLogSettings.map(value => value.buildAwsValue())
      )(_.conversationLogSettings)
      .optionallyWith(
        sentimentAnalysisSettings.map(value => value.buildAwsValue())
      )(_.sentimentAnalysisSettings)
      .optionallyWith(botAliasStatus.map(value => value.unwrap))(
        _.botAliasStatus
      )
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.CreateBotAliasResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.CreateBotAliasResponse.wrap(buildAwsValue())
}
object CreateBotAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.CreateBotAliasResponse =
      zio.aws.lexmodelsv2.model.CreateBotAliasResponse(
        botAliasId.map(value => value),
        botAliasName.map(value => value),
        description.map(value => value),
        botVersion.map(value => value),
        botAliasLocaleSettings.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        conversationLogSettings.map(value => value.asEditable),
        sentimentAnalysisSettings.map(value => value.asEditable),
        botAliasStatus.map(value => value),
        botId.map(value => value),
        creationDateTime.map(value => value),
        tags.map(value => value)
      )
    def botAliasId: Option[BotAliasId]
    def botAliasName: Option[Name]
    def description: Option[Description]
    def botVersion: Option[NumericalBotVersion]
    def botAliasLocaleSettings: Option[
      Map[LocaleId, zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.ReadOnly]
    ]
    def conversationLogSettings
        : Option[zio.aws.lexmodelsv2.model.ConversationLogSettings.ReadOnly]
    def sentimentAnalysisSettings
        : Option[zio.aws.lexmodelsv2.model.SentimentAnalysisSettings.ReadOnly]
    def botAliasStatus: Option[zio.aws.lexmodelsv2.model.BotAliasStatus]
    def botId: Option[Id]
    def creationDateTime: Option[Timestamp]
    def tags: Option[Map[TagKey, TagValue]]
    def getBotAliasId: ZIO[Any, AwsError, BotAliasId] =
      AwsError.unwrapOptionField("botAliasId", botAliasId)
    def getBotAliasName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("botAliasName", botAliasName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getBotVersion: ZIO[Any, AwsError, NumericalBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getBotAliasLocaleSettings: ZIO[Any, AwsError, Map[
      LocaleId,
      zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "botAliasLocaleSettings",
      botAliasLocaleSettings
    )
    def getConversationLogSettings: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ConversationLogSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "conversationLogSettings",
      conversationLogSettings
    )
    def getSentimentAnalysisSettings: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.SentimentAnalysisSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sentimentAnalysisSettings",
      sentimentAnalysisSettings
    )
    def getBotAliasStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotAliasStatus] =
      AwsError.unwrapOptionField("botAliasStatus", botAliasStatus)
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasResponse
  ) extends zio.aws.lexmodelsv2.model.CreateBotAliasResponse.ReadOnly {
    override val botAliasId: Option[BotAliasId] = scala
      .Option(impl.botAliasId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotAliasId(value))
    override val botAliasName: Option[Name] = scala
      .Option(impl.botAliasName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val botVersion: Option[NumericalBotVersion] = scala
      .Option(impl.botVersion())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.NumericalBotVersion(value)
      )
    override val botAliasLocaleSettings: Option[
      Map[LocaleId, zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.ReadOnly]
    ] = scala
      .Option(impl.botAliasLocaleSettings())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.primitives.LocaleId(
              key
            ) -> zio.aws.lexmodelsv2.model.BotAliasLocaleSettings.wrap(value)
          })
          .toMap
      )
    override val conversationLogSettings
        : Option[zio.aws.lexmodelsv2.model.ConversationLogSettings.ReadOnly] =
      scala
        .Option(impl.conversationLogSettings())
        .map(value =>
          zio.aws.lexmodelsv2.model.ConversationLogSettings.wrap(value)
        )
    override val sentimentAnalysisSettings
        : Option[zio.aws.lexmodelsv2.model.SentimentAnalysisSettings.ReadOnly] =
      scala
        .Option(impl.sentimentAnalysisSettings())
        .map(value =>
          zio.aws.lexmodelsv2.model.SentimentAnalysisSettings.wrap(value)
        )
    override val botAliasStatus
        : Option[zio.aws.lexmodelsv2.model.BotAliasStatus] = scala
      .Option(impl.botAliasStatus())
      .map(value => zio.aws.lexmodelsv2.model.BotAliasStatus.wrap(value))
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val creationDateTime: Option[Timestamp] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexmodelsv2.model.primitives.TagKey(
              key
            ) -> zio.aws.lexmodelsv2.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateBotAliasResponse
  ): zio.aws.lexmodelsv2.model.CreateBotAliasResponse.ReadOnly = new Wrapper(
    impl
  )
}
