package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  DraftBotVersion,
  Description,
  Name,
  BuiltInOrCustomSlotTypeId,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateSlotRequest(
    slotName: Name,
    description: Option[Description] = None,
    slotTypeId: BuiltInOrCustomSlotTypeId,
    valueElicitationSetting: zio.aws.lexmodelsv2.model.SlotValueElicitationSetting,
    obfuscationSetting: Option[zio.aws.lexmodelsv2.model.ObfuscationSetting] =
      None,
    botId: Id,
    botVersion: DraftBotVersion,
    localeId: LocaleId,
    intentId: Id,
    multipleValuesSetting: Option[
      zio.aws.lexmodelsv2.model.MultipleValuesSetting
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotRequest = {
    import CreateSlotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotRequest
      .builder()
      .slotName(Name.unwrap(slotName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .slotTypeId(
        BuiltInOrCustomSlotTypeId.unwrap(slotTypeId): java.lang.String
      )
      .valueElicitationSetting(valueElicitationSetting.buildAwsValue())
      .optionallyWith(obfuscationSetting.map(value => value.buildAwsValue()))(
        _.obfuscationSetting
      )
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(DraftBotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .intentId(Id.unwrap(intentId): java.lang.String)
      .optionallyWith(
        multipleValuesSetting.map(value => value.buildAwsValue())
      )(_.multipleValuesSetting)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.CreateSlotRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.CreateSlotRequest.wrap(buildAwsValue())
}
object CreateSlotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.CreateSlotRequest =
      zio.aws.lexmodelsv2.model.CreateSlotRequest(
        slotName,
        description.map(value => value),
        slotTypeId,
        valueElicitationSetting.asEditable,
        obfuscationSetting.map(value => value.asEditable),
        botId,
        botVersion,
        localeId,
        intentId,
        multipleValuesSetting.map(value => value.asEditable)
      )
    def slotName: Name
    def description: Option[Description]
    def slotTypeId: BuiltInOrCustomSlotTypeId
    def valueElicitationSetting
        : zio.aws.lexmodelsv2.model.SlotValueElicitationSetting.ReadOnly
    def obfuscationSetting
        : Option[zio.aws.lexmodelsv2.model.ObfuscationSetting.ReadOnly]
    def botId: Id
    def botVersion: DraftBotVersion
    def localeId: LocaleId
    def intentId: Id
    def multipleValuesSetting
        : Option[zio.aws.lexmodelsv2.model.MultipleValuesSetting.ReadOnly]
    def getSlotName: ZIO[Any, Nothing, Name] = ZIO.succeed(slotName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSlotTypeId: ZIO[Any, Nothing, BuiltInOrCustomSlotTypeId] =
      ZIO.succeed(slotTypeId)
    def getValueElicitationSetting: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.SlotValueElicitationSetting.ReadOnly
    ] = ZIO.succeed(valueElicitationSetting)
    def getObfuscationSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ObfuscationSetting.ReadOnly
    ] = AwsError.unwrapOptionField("obfuscationSetting", obfuscationSetting)
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, DraftBotVersion] =
      ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getIntentId: ZIO[Any, Nothing, Id] = ZIO.succeed(intentId)
    def getMultipleValuesSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.MultipleValuesSetting.ReadOnly
    ] =
      AwsError.unwrapOptionField("multipleValuesSetting", multipleValuesSetting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotRequest
  ) extends zio.aws.lexmodelsv2.model.CreateSlotRequest.ReadOnly {
    override val slotName: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.slotName())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val slotTypeId: BuiltInOrCustomSlotTypeId =
      zio.aws.lexmodelsv2.model.primitives
        .BuiltInOrCustomSlotTypeId(impl.slotTypeId())
    override val valueElicitationSetting
        : zio.aws.lexmodelsv2.model.SlotValueElicitationSetting.ReadOnly =
      zio.aws.lexmodelsv2.model.SlotValueElicitationSetting
        .wrap(impl.valueElicitationSetting())
    override val obfuscationSetting
        : Option[zio.aws.lexmodelsv2.model.ObfuscationSetting.ReadOnly] = scala
      .Option(impl.obfuscationSetting())
      .map(value => zio.aws.lexmodelsv2.model.ObfuscationSetting.wrap(value))
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: DraftBotVersion =
      zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
    override val intentId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.intentId())
    override val multipleValuesSetting
        : Option[zio.aws.lexmodelsv2.model.MultipleValuesSetting.ReadOnly] =
      scala
        .Option(impl.multipleValuesSetting())
        .map(value =>
          zio.aws.lexmodelsv2.model.MultipleValuesSetting.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateSlotRequest
  ): zio.aws.lexmodelsv2.model.CreateSlotRequest.ReadOnly = new Wrapper(impl)
}
