package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{SessionId, LocaleId, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteUtterancesRequest(
    botId: Id,
    localeId: Option[LocaleId] = None,
    sessionId: Option[SessionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteUtterancesRequest = {
    import DeleteUtterancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteUtterancesRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DeleteUtterancesRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteUtterancesRequest.wrap(buildAwsValue())
}
object DeleteUtterancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteUtterancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteUtterancesRequest =
      zio.aws.lexmodelsv2.model.DeleteUtterancesRequest(
        botId,
        localeId.map(value => value),
        sessionId.map(value => value)
      )
    def botId: Id
    def localeId: Option[LocaleId]
    def sessionId: Option[SessionId]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteUtterancesRequest
  ) extends zio.aws.lexmodelsv2.model.DeleteUtterancesRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val localeId: Option[LocaleId] = scala
      .Option(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val sessionId: Option[SessionId] = scala
      .Option(impl.sessionId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.SessionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteUtterancesRequest
  ): zio.aws.lexmodelsv2.model.DeleteUtterancesRequest.ReadOnly = new Wrapper(
    impl
  )
}
