package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters.*
sealed trait ImportResourceType {
  def unwrap
      : software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceType
}
object ImportResourceType {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceType
  ): zio.aws.lexmodelsv2.model.ImportResourceType = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceType.BOT =>
      val r = Bot
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceType.BOT_LOCALE =>
      val r = BotLocale
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceType.CUSTOM_VOCABULARY =>
      val r = CustomVocabulary
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.ImportResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceType =
      software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object Bot extends zio.aws.lexmodelsv2.model.ImportResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceType =
      software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceType.BOT
  }
  case object BotLocale extends zio.aws.lexmodelsv2.model.ImportResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceType =
      software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceType.BOT_LOCALE
  }
  case object CustomVocabulary
      extends zio.aws.lexmodelsv2.model.ImportResourceType {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceType =
      software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceType.CUSTOM_VOCABULARY
  }
}
