package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.BoxedBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class IntentConfirmationSetting(
    promptSpecification: zio.aws.lexmodelsv2.model.PromptSpecification,
    declinationResponse: zio.aws.lexmodelsv2.model.ResponseSpecification,
    active: Option[BoxedBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.IntentConfirmationSetting = {
    import IntentConfirmationSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.IntentConfirmationSetting
      .builder()
      .promptSpecification(promptSpecification.buildAwsValue())
      .declinationResponse(declinationResponse.buildAwsValue())
      .optionallyWith(
        active.map(value => BoxedBoolean.unwrap(value): java.lang.Boolean)
      )(_.active)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.IntentConfirmationSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.IntentConfirmationSetting.wrap(buildAwsValue())
}
object IntentConfirmationSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.IntentConfirmationSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.IntentConfirmationSetting =
      zio.aws.lexmodelsv2.model.IntentConfirmationSetting(
        promptSpecification.asEditable,
        declinationResponse.asEditable,
        active.map(value => value)
      )
    def promptSpecification
        : zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly
    def declinationResponse
        : zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    def active: Option[BoxedBoolean]
    def getPromptSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly
    ] = ZIO.succeed(promptSpecification)
    def getDeclinationResponse: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly
    ] = ZIO.succeed(declinationResponse)
    def getActive: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("active", active)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentConfirmationSetting
  ) extends zio.aws.lexmodelsv2.model.IntentConfirmationSetting.ReadOnly {
    override val promptSpecification
        : zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly =
      zio.aws.lexmodelsv2.model.PromptSpecification
        .wrap(impl.promptSpecification())
    override val declinationResponse
        : zio.aws.lexmodelsv2.model.ResponseSpecification.ReadOnly =
      zio.aws.lexmodelsv2.model.ResponseSpecification
        .wrap(impl.declinationResponse())
    override val active: Option[BoxedBoolean] = scala
      .Option(impl.active())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BoxedBoolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.IntentConfirmationSetting
  ): zio.aws.lexmodelsv2.model.IntentConfirmationSetting.ReadOnly = new Wrapper(
    impl
  )
}
