package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.{NextToken, MaxResults, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListBotVersionsRequest(
    botId: Id,
    sortBy: Option[zio.aws.lexmodelsv2.model.BotVersionSortBy] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest = {
    import ListBotVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListBotVersionsRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.ListBotVersionsRequest.wrap(buildAwsValue())
}
object ListBotVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListBotVersionsRequest =
      zio.aws.lexmodelsv2.model.ListBotVersionsRequest(
        botId,
        sortBy.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def botId: Id
    def sortBy: Option[zio.aws.lexmodelsv2.model.BotVersionSortBy.ReadOnly]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.BotVersionSortBy.ReadOnly
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest
  ) extends zio.aws.lexmodelsv2.model.ListBotVersionsRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val sortBy
        : Option[zio.aws.lexmodelsv2.model.BotVersionSortBy.ReadOnly] = scala
      .Option(impl.sortBy())
      .map(value => zio.aws.lexmodelsv2.model.BotVersionSortBy.wrap(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.lexmodelsv2.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionsRequest
  ): zio.aws.lexmodelsv2.model.ListBotVersionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
