package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListBotsResponse(
    botSummaries: Option[Iterable[zio.aws.lexmodelsv2.model.BotSummary]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse = {
    import ListBotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse
      .builder()
      .optionallyWith(
        botSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.botSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListBotsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListBotsResponse.wrap(buildAwsValue())
}
object ListBotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListBotsResponse =
      zio.aws.lexmodelsv2.model.ListBotsResponse(
        botSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def botSummaries
        : Option[List[zio.aws.lexmodelsv2.model.BotSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getBotSummaries: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.BotSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("botSummaries", botSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse
  ) extends zio.aws.lexmodelsv2.model.ListBotsResponse.ReadOnly {
    override val botSummaries
        : Option[List[zio.aws.lexmodelsv2.model.BotSummary.ReadOnly]] = scala
      .Option(impl.botSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.BotSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse
  ): zio.aws.lexmodelsv2.model.ListBotsResponse.ReadOnly = new Wrapper(impl)
}
